<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\OneSignalService;
use App\Models\Deal;

/**
 * Artisan command to send notifications about new deals.
 */
class SendNewDealsNotification extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'notification:send-new-deals';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send notifications for new deals and news';

    /**
     * OneSignal service instance.
     *
     * @var OneSignalService
     */
    protected $oneSignalService;

    /**
     * Create a new command instance.
     *
     * @param OneSignalService $oneSignalService
     * @return void
     */
    public function __construct(OneSignalService $oneSignalService)
    {
        parent::__construct();
        $this->oneSignalService = $oneSignalService;
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // Fetch new deals added in the last 24 hours
        $newDeals = Deal::where('created_at', '>=', now()->subDay())->get();

        if ($newDeals->isEmpty()) {
            $this->info('No new deals to notify.');
            return 0;
        }

        // Prepare notification content
        $title = 'New Deals Available!';
        $message = 'Check out the latest deals on our platform.';
        $url = route('deals.index'); // Link to the deals page
        $image = asset('images/notifications/new_deals.png'); // Optional default image

        // Send notification
        $result = $this->oneSignalService->sendNotification($title, $message, $url, $image);

        if ($result) {
            $this->info('Notifications sent successfully.');
        } else {
            $this->error('Failed to send notifications.');
        }

        return 0;
    }
}
