<?php
namespace App\Http\Controllers;
use App\Http\Requests\SellerRegistrationRequest;
use App\Mail\NewSellerMailManager;
use Illuminate\Http\Request;
use App\Models\Shop;
use App\Models\User;
use App\Models\BusinessSetting;
use Auth;
use Hash;
use Mail;
use App\Notifications\EmailVerificationNotification;
use Illuminate\Support\Facades\Notification;
class ShopController extends Controller
{
    public function __construct()
    {
        $this->middleware('user', ['only' => ['index']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $shop = Auth::user()->shop;
        return view('seller.shop', compact('shop'));
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (Auth::check()) {
            if ((Auth::user()->user_type == 'admin' || Auth::user()->user_type == 'customer')) {
                flash(translate('Admin or Customer cannot be a seller'))->error();
                return back();
            }
            if (Auth::user()->user_type == 'seller') {
                flash(translate('This user already a seller'))->error();
                return back();
            }
        } else {
            return view('auth.' . get_setting('authentication_layout_select') . '.seller_registration');
        }
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(SellerRegistrationRequest $request)
    {
        $first_name = $request->first_name;
        $last_name = $request->last_name;
        $company_name = $request->company_name;
        $category_id = $request->category;
        $phone = $request->phone;
        $email = $request->email;
        $address = $request->address;
        $city = $request->city;

        $user = new User;
        $user->user_type = "seller";
        $user->name = $first_name . ' ' . $last_name;
        $user->first_name = $first_name;
        $user->last_name = $last_name;
        $user->email = $email;
        $user->phone = $phone;
        $user->address = $address;
        $user->city = $city;

        if ($user->save()) {
            $shop = new Shop;
            $shop->user_id = $user->id;
            $shop->category_id = $category_id;
            $shop->name = $company_name;
            $shop->phone = $phone;
            $shop->address = $address;
            $shop->slug = preg_replace('/\s+/', '-', str_replace("/", " ", $company_name));
            $shop->save();

            // auth()->login($user, false);
            // if (BusinessSetting::where('type', 'email_verification')->first()->value == 0) {
            //     $user->email_verified_at = date('Y-m-d H:m:s');
            //     $user->save();
            // } else {
            //     try {
            //         $user->notify(new EmailVerificationNotification());
            //     } catch (\Throwable $th) {
            //         $shop->delete();
            //         $user->delete();
            //         flash(translate('Seller registration failed. Please try again later.'))->error();
            //         return back();
            //     }
            // }

            // flash(translate('Your Shop has been created successfully!'))->success();
            // return redirect()->route('seller.shop.index');

            $data = [
                'first_name' => $first_name,
                'last_name' => $last_name,
                'company_name' => $company_name,
                'email' => $email,
                'phone' => $phone,
            ];

            $data['template'] = 'emails.new_seller';
            $data['subject'] = translate('Deelgo | New Seller');

            Mail::to('commercial@deelgo.com')->queue(new NewSellerMailManager($data));
            flash(translate('Votre demande a été envoyée'))->success();
            return back();
        }

        flash(translate('Sorry! Something went wrong.'))->error();
        return back();
    }
    public function success()
    {
        return view('auth.' . get_setting('authentication_layout_select') . '.seller_registration_success');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }
    public function destroy($id)
    {
        //
    }
}
