<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\Subscriber;
use Mail;
use App\Mail\NewsletterMailManager;

class SubscriberController extends Controller
{
    public function __construct()
    {
        // Staff Permission Check
        $this->middleware(['permission:view_all_subscribers'])->only('index');
        $this->middleware(['permission:delete_subscriber'])->only('destroy');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $subscribers = Subscriber::orderBy('created_at', 'desc')->paginate(15);
        return view('backend.marketing.subscribers.index', compact('subscribers'));
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $subscriber = Subscriber::where('email', $request->email)->first();
        if ($subscriber == null) {
            $subscriber = new Subscriber;
            $subscriber->email = $request->email;
            $subscriber->save();
            
            $validated['subject'] = translate('Objet') .':'. translate('Un nouvel utilisateur s’est inscrit à la newsletter');
            $validated['template'] = 'emails.newsletter';
    
            // $validated['content'] = $validated['subject'];
            $validated['content'] = '<p>' . translate('Bonjour,') . '</p>';
            $validated['content'] .= '<p>' . translate('Nous souhaitons vous informer qu’un nouveau contact s’est inscrit à la newsletter. Voici les informations recueillies :') . '</p>';
            $validated['content'] .= '<p><b>' . translate('Adresse e-mail') . '</b> :' . $request->email . '</p>';
            $validated['content'] .= '<p>' . translate('Merci de bien vouloir prendre en compte cette nouvelle inscription dans le suivi et l’animation de la base de contacts.') . '</p>';
            $validated['content'] .= '<p>' . translate('Cordialement,') . '</p>';
    
            Mail::to('info@deelgo.com')->queue(new NewsletterMailManager($validated));
            
            $validated['subject'] = translate('Objet') .':'. translate(' Confirmation de votre inscription à notre newsletter');
            $validated['template'] = 'emails.newsletter';
    
            // $validated['content'] = $validated['subject'];
            $validated['content'] = '<p>' . translate('Bonjour,') . '</p>';
            $validated['content'] .= '<p>' . translate('Nous vous remercions de vous être inscrit(e) à notre newsletter !') . '</p>';
            $validated['content'] .= '<p>' . translate('Vous recevrez désormais nos dernières actualités et nos offres exclusives directement dans votre boîte e-mail.') . '</p>';
            $validated['content'] .= '<p>' . translate('Nous respectons scrupuleusement votre vie privée ainsi que nos engagements en matière de confidentialité, et nous nous engageons à ne pas vous envoyer de messages indésirables.') . '</p>';
            $validated['content'] .= '<p>' . translate('Toutefois, si vous ne souhaitez plus recevoir nos e-mails, vous pouvez à tout moment vous désinscrire en cliquant sur ce lien : ') . '</p>';
            $validated['content'] .= '<a href="' . route('subscribers.unsubscribe', ['email' => $request->email]) . '">'. translate('désinscription') .'</a>';
            $validated['content'] .= '<p><b>' . translate('Merci pour votre confiance et à très bientôt !') . '</b></p>';
            $validated['content'] .= '<p>' . translate('Cordialement,') . '</p>';
    
            Mail::to($request->email)->queue(new NewsletterMailManager($validated));
            
            $message = translate('You have subscribed successfully');
            $status = 'success';
        } else {
            $message = translate('You are already a subscriber');
            $status = 'success';
        }

        if ($request->ajax()) {
            return response()->json(['message' => $message, 'status' => $status]);
        }

        flash($message)->success();
        return back();
    }

    public function unsubscribe(Request $request)
    {
        $email = $request->email;
        $confirm = $request->confirm;
        
        if ($confirm) {
            Subscriber::where('email', $email)->delete();
            
            flash(translate('Subscriber has been deleted successfully'))->success();
            return redirect()->route('home');
        }
        
        return view('frontend.subscribers.unsubscribe');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Subscriber::destroy($id);
        flash(translate('Subscriber has been deleted successfully'))->success();
        return redirect()->route('subscribers.index');
    }
}
