<?php

namespace App\Http\Middleware;

use Illuminate\Auth\Middleware\Authenticate as Middleware;

class Authenticate extends Middleware
{
    /**
     * Get the path the user should be redirected to when they are not authenticated.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return string
     */
    protected function redirectTo($request)
    {
        // return route('user.login');

        $path = $request->path();
        if ($path === 'admin') {
            return route('admin.login');
        } elseif ($path === 'seller') {
            return route('seller.login');
        }
        return route('user.login');
    }
}
