<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CareersMailManager extends Mailable
{
    use Queueable, SerializesModels;

    public $array;
    public $filePath;

    public function __construct($array, $filePath = null)
    {
        $this->array = $array;
        $this->filePath = $filePath;
    }

    public function build()
    {
        $email = $this->view($this->array['template'])
            ->from(env('MAIL_FROM_ADDRESS'), env('APP_NAME'))
            ->subject($this->array['subject'])
            ->with([
                'content' => $this->array['content'],
            ]);

        if ($this->filePath) {
            $email->attach($this->filePath, [
                'as' => 'attachment.' . pathinfo($this->filePath, PATHINFO_EXTENSION),
                'mime' => mime_content_type($this->filePath),
            ]);
        }

        return $email;
    }
}