<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ContactMailManager extends Mailable
{
    use Queueable, SerializesModels;

    public $array;

    public function __construct($array)
    {
        $this->array = $array;
    }

    public function build()
    {
        return $this->view($this->array['template'])
            ->from(env('MAIL_FROM_ADDRESS'), env('APP_NAME'))
            ->subject($this->array['subject'])
            ->with([
                'first_name' => $this->array['first_name'],
                'last_name' => $this->array['last_name'],
                'email' => $this->array['email'],
                'phone' => $this->array['phone'],
                'subject' => $this->array['subject'],
                'content' => $this->array['message'],
            ]);
    }
}