<?php
namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class NewReviewMailManager extends Mailable
{
    use Queueable, SerializesModels;

    public $array;

    public function __construct($array)
    {
        $this->array = $array;
    }

    public function build()
    {
        return $this->view($this->array['template'])
            ->from(env('MAIL_FFROM_ADDRESS'), env('APP_NAME'))
            ->subject($this->array['subject'])
            ->with([
                'product_name' => $this->array['product_name'],
                'review_message' => $this->array['review_message'],
            ]);
    }
}