<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class NewsletterMailManager extends Mailable
{
    use Queueable, SerializesModels;

    public $array;

    public function __construct($array)
    {
        $this->array = $array;
    }

    public function build()
    {
        return $this->view($this->array['template'])
            ->from(env('MAIL_FROM_ADDRESS'), env('APP_NAME'))
            ->subject($this->array['subject'])
            ->with([
                'content' => $this->array['content'],
            ]);
    }
}