<?php
namespace App\Notifications;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
class ShopVerificationNotification extends Notification
{
    use Queueable;
    public $data;
    public $className;
    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        $this->data = $data;
        $this->className = ShopVerificationNotification::class;
    }
    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return [DbNotification::class];
    }
    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $password_reset_url = env('APP_URL') . '/password/reset/';
        return (new MailMessage)
            ->line('Your account has been approved, and you can reset your account password from the link below.')
            ->action('Reset Password', $password_reset_url);
    }
    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'notification_type_id' => $this->data['notification_type_id'],
            'data' => [
                'name' => $this->data['shop']['name'],
                'id' => $this->data['shop']['id'],
                'status' => $this->data['status']
            ]
        ];
    }
}
