<?php
namespace App\Utility;
use App\Models\Addon;
use App\Models\Color;
use App\Models\Product;
class ProductUtility
{
    public static function get_attribute_options($collection)
    {
        $options = array();
        if (
            isset($collection['colors_active']) &&
            $collection['colors_active'] &&
            $collection['colors'] &&
            count($collection['colors']) > 0
        ) {
            $colors_active = 1;
            array_push($options, $collection['colors']);
        }
        if (isset($collection['choice_no']) && $collection['choice_no']) {
            foreach ($collection['choice_no'] as $key => $no) {
                $name = 'choice_options_' . $no;  
                $data = array();
                foreach (request()[$name] as $key => $eachValue) {
                    array_push($data, $eachValue);
                }
                array_push($options, $data);
            }
        }
        return $options;
    }
    public static function get_attributes_values($collection) {
        $values = [];
        if (isset($collection['choice_no']) && $collection['choice_no']) {
            foreach ($collection['choice_no'] as $key => $no) {
                $labels_name = 'attribute_' . $no . '_labels';
                $prices_name = 'attribute_' . $no . '_prices';
                foreach (request()[$labels_name] as $key => $value) {
                    $attr_value['attribute_id'] = $no;
                    $attr_value['value'] = $value;
                    $attr_value['price'] = request()[$prices_name][$key];
                    $values[] = $attr_value;
                }
            }
        }
        return $values;
    }
    public static function get_combination_string($combination, $collection)
    {
        $str = '';
        foreach ($combination as $key => $item) {
            if ($key > 0) {
                $str .= '-' . str_replace(' ', ' ', $item);
            } else {
                if (isset($collection['colors_active']) && $collection['colors_active'] && $collection['colors'] && count($collection['colors']) > 0) {
                    $color_name = Color::where('code', $item)->first()->name;
                    $str .= $color_name;
                } else {
                    $str .= str_replace(' ', ' ', $item); 
                }
            }
        }
        return $str;
    }
    public static function add_product_to_group($product_id, $group_id) {
        $product = Product::find($product_id);
        $product->is_grouped = 1;
        $product->group_id = $group_id;
        $product->save();
    }
}
