<?php

namespace Deelgo\QRgenerator\Providers;

use Illuminate\Support\ServiceProvider;

class QRgeneratorServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        // Register the package services, e.g., binding services into the container

        if (file_exists(__DIR__ . '/../lib/functions.php')) {
            require_once __DIR__ . '/../lib/functions.php';
        }

        if (file_exists(__DIR__ . '/../lib/phpqrcode.php')) {
            require_once __DIR__ . '/../lib/phpqrcode.php';
        }

        if (file_exists(__DIR__ . '/../lib/frames.php')) {
            require_once __DIR__ . '/../lib/frames.php';
        }

        if (file_exists(__DIR__ . '/../lib/markers.php')) {
            require_once __DIR__ . '/../lib/markers.php';
        }

        if (file_exists(__DIR__ . '/../lib/countrycodes.php')) {
            require_once __DIR__ . '/../lib/countrycodes.php';
        }
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        // Load routes, views, migrations, etc.
    }
}
