<?php

namespace Deelgo\QRgenerator;

class QRgenerator
{
    public static function generateEventQR($event)
    {
        require_once __DIR__ . '/lib/phpqrcode.php';
        require_once __DIR__ . '/lib/class-qrcdr.php';

        $output_data = false;

        $backcolor = 0xFFFFFF;
        $frontcolor = 0x000000;
        $gradient_color = '#8900d5';
        $pattern = 'circle';
        $markerOut = 'rounded';
        $markerIn = 'circle';
        $markerOutColor = "#000000";
        $markerInColor = "#000000";
        $marker_top_right_outline = "#000000";
        $marker_top_right_center = "#000000";
        $marker_bottom_left_outline = "#000000";
        $marker_bottom_left_center = "#000000";
        $optionLogo = 'none';
        $logoSize = 100;
        $frameColor = '#000000';
        $frameLabel = 'SCAN ME';
        $labelFont = 'AbrilFatface.svg';
        $labelTextSize = '100';
        $labelTextColor = '#ffffff';
        $outerframe = 'none';
        $size = 32;
        $level = 'Q';
        $errorCorrectionLevel = 2;
        $matrixPointSize = min(max((int) $size, 4), 32);

        $optionstyle = array(
            'optionlogo' => $optionLogo,
            'pattern' => $pattern,
            'marker_out' => $markerOut,
            'marker_in' => $markerIn,
            'marker_out_color' => $markerOutColor,
            'marker_in_color' => $markerInColor,
            'marker_top_right_outline' => $marker_top_right_outline,
            'marker_top_right_center' => $marker_top_right_center,
            'marker_bottom_left_outline' => $marker_bottom_left_outline,
            'marker_bottom_left_center' => $marker_bottom_left_center,
            'gradient' => false,
            'gradient_color' => $gradient_color,
            'markers_color' => false,
            'radial' => false,
            'no_logo_bg' => true,
            'frame' => 'none',
            'custom_frame_color' => false,
            'framecolor' => $frameColor,
            'framelabel' => $frameLabel,
            'label_font' => $labelFont,
            'labeltext_color' => $labelTextColor,
            'logo_size' => $logoSize,
            'label_text_size' => $labelTextSize,
            'transparent_code' => false,
            'bg_image' => 'none',
            'negative' => false,
        );

        $frames = array(
            'none' => array(
                'path' => '<polygon points="18.7,6.6 12,13.3 5.3,6.6 4.6,7.3 11.3,14 4.6,20.7 5.3,21.4 12,14.7 18.7,21.4 19.4,20.7 12.7,14 19.4,7.3 "/>',
            ),
            'bottom' => array(
                'path' => '<path d="M22.7,0H1.3C0.6,0,0,0.6,0,1.3v25.3C0,27.4,0.6,28,1.3,28h21.3c0.7,0,1.3-0.6,1.3-1.3V1.3C24,0.6,23.4,0,22.7,0 z M23,22c0,0.6-0.5,1-1,1H2c-0.6,0-1-0.5-1-1V2c0-0.6,0.5-1,1-1h20c0.6,0,1,0.5,1,1V22z"/>',
                'label_pos' => 'bottom',
                'label_size' => 3,
                'label_offset' => 0,
                'frame_border' => 1,
            ),
            'top' => array(
                'path' => '<path d="M1.3,28L22.6,28c0.7,0,1.3-0.6,1.3-1.3L24,1.4c0-0.7-0.6-1.3-1.3-1.3L1.4,0C0.7,0,0.1,0.6,0,1.3L0,26.6 C-0.1,27.4,0.5,28,1.3,28z M1,6c0-0.6,0.5-1,1-1L22,5c0.6,0,1,0.5,1,1L23,26c0,0.6-0.5,1-1,1L2,27c-0.6,0-1-0.5-1-1L1,6z"/>',
                'label_pos' => 'top',
                'label_size' => 3,
                'label_offset' => 0,
                'frame_border' => 1,
            ),
            'balloon-bottom' => array(
                'path' => '<path d="M1.3,24l21.3,0c0.7,0,1.3-0.6,1.3-1.3l0-21.3C24,0.6,23.4,0,22.7,0L1.3,0C0.6,0,0,0.6,0,1.3l0,21.3 C0,23.4,0.6,24,1.3,24z M1,2c0-0.6,0.5-1,1-1l20,0c0.6,0,1,0.5,1,1v20c0,0.6-0.5,1-1,1L2,23c-0.6,0-1-0.5-1-1V2z"/><path d="M1,30h22c0.5,0,1-0.4,1-1v-3c0-0.5-0.4-1-1-1H13l-1-1l-1,1H1c-0.5,0-1,0.4-1,1v3C0,29.6,0.4,30,1,30z"/>',
                'label_pos' => 'bottom',
                'label_size' => 3,
                'label_offset' => 2,
                'frame_border' => 1,
            ),
            'balloon-top' => array(
                'path' => '<path d="M22.7,6L1.3,6C0.6,6,0,6.6,0,7.3l0,21.3C0,29.4,0.6,30,1.3,30l21.3,0c0.7,0,1.3-0.6,1.3-1.3l0-21.3 C24,6.6,23.4,6,22.7,6z M23,28c0,0.6-0.5,1-1,1L2,29c-0.6,0-1-0.5-1-1V8c0-0.6,0.5-1,1-1l20,0c0.6,0,1,0.5,1,1V28z"/><path d="M23,0H1C0.4,0,0,0.4,0,1v3c0,0.5,0.4,1,1,1h10l1,1l1-1h10c0.5,0,1-0.4,1-1V1C24,0.4,23.6,0,23,0z"/>',
                'label_pos' => 'top',
                'label_size' => 3,
                'label_offset' => 2,
                'frame_border' => 1,
            ),
            'ribbon-bottom' => array(
                'path' => '<path d="M24,21h-1.7V1.7H1.7V21H0l1,2l-1,2h1v2h22v-2h1l-1-2L24,21z M2,2h20v19v1H2v-1V2z"/>',
                'label_pos' => 'bottom',
                'label_size' => 3,
                'label_offset' => -1,
                'frame_border' => 2,
            ),
            'ribbon-top' => array(
                'path' => '<path d="M0,6h1.7v19.3h20.7V6H24l-1-2l1-2h-1V0H1v2H0l1,2L0,6z M22,25H2V6V5h20v1V25z"/>',
                'label_pos' => 'top',
                'label_size' => 3,
                'label_offset' => -1,
                'frame_border' => 2,
            ),
            'phone' => array(
                'path' => '<path d="M17.6,0H6.4c-1,0-1.8,0.8-1.8,1.8v20.4c0,1,0.8,1.8,1.8,1.8h11.1c1,0,1.8-0.8,1.8-1.8V1.8C19.4,0.8,18.6,0,17.6,0z M11.2,2.3h2.7c0.1,0,0.2,0.1,0.2,0.2S14,2.7,13.9,2.7h-2.7c-0.1,0-0.2-0.1-0.2-0.2S11.1,2.3,11.2,2.3z M10.1,2.3 c0.1,0,0.2,0.1,0.2,0.2s-0.1,0.2-0.2,0.2c-0.1,0-0.2-0.1-0.2-0.2S10,2.3,10.1,2.3z M19,19H5V5h14V19z"/>',
                'label_pos' => 'bottom',
                'label_size' => 4,
                'label_offset' => -4.5,
                'frame_border' => 5,
            ),
            'cine' => array(
                'path' => '<path d="M4.5,4.5L4.5,4.5L4.5,4.5l0,17.2c0,0.3,0.3,0.6,0.6,0.6h13.8c0.3,0,0.6-0.3,0.6-0.6V4.5H4.5z M19,18.6
        c0,0.2-0.2,0.4-0.4,0.4H5.4C5.2,19,5,18.8,5,18.6V5.4C5,5.2,5.2,5,5.4,5h13.1C18.8,5,19,5.2,19,5.4V18.6z"/><path d="M19.1,0.1L4.2,1.7l0.3,2.8l14.9-1.6L19.1,0.1z M6.8,3.8L4.9,4l1.7-2.1l1.9-0.2L6.8,3.8z M10.5,3.4L8.6,3.6l1.7-2.1l1.9-0.2 L10.5,3.4z M14.2,3l-1.9,0.2L14,1.1l1.9-0.2L14.2,3z M18,2.6l-1.9,0.2l1.7-2.1l0.9-0.1l0.1,0.9L18,2.6z"/>',
                'label_pos' => 'bottom',
                'label_size' => 2.5,
                'label_offset' => -4.6,
                'frame_border' => 5,
            ),
        );

        $title = isset($event['title']) ? $event['title'] : 'Test';
        $location = isset($event['location']) ? $event['location'] : '';

        $starttime = isset($event['start_date']) ? $event['start_date'] : '123456';
        $endtime = isset($event['end_date']) ? $event['end_date'] : '';

        $reminder = '-PT24H';
        $eventurl = isset($event['url']) ? $event['url'] : '#';

        $eventnote = 'Test+Note+...';

        if ($title && $starttime) {
            $output_data = 'BEGIN:VCALENDAR' . "\n";
            $output_data .= 'BEGIN:VEVENT' . "\n";
            if ($location) {
                $location = str_replace(';', '\;', str_replace(',', '\,', $location));
                $output_data .= 'LOCATION:' . $location . "\n";
            }
            $formatstart = date('Ymd\THis\Z', $starttime);
            $output_data .= 'DTSTART:' . $formatstart . "\n";

            if ($endtime) {
                $formatend = date('Ymd\THis\Z', $endtime);
                $output_data .= 'DTEND:' . $formatend . "\n";
            }
            $output_data .= 'SUMMARY:' . $title . "\n";

            if ($eventnote) {
                $eventnote = str_replace("\r\n", "\\n", $eventnote);
                $output_data .= 'DESCRIPTION:' . $eventnote . "\n";
            }
            if ($eventurl) {
                $output_data .= 'URL:' . $eventurl . "\n";
                $output_data .= 'CLASS:PUBLIC' . "\n";
            }
            if ($reminder) {
                $output_data .= 'BEGIN:VALARM' . "\n";
                $output_data .= 'TRIGGER:' . $reminder . "\n";

                $output_data .= 'ACTION:DISPLAY' . "\n";
                $output_data .= 'DESCRIPTION:Reminder' . "\n";
                $output_data .= 'END:VALARM' . "\n";
            }
            $output_data .= 'END:VEVENT' . "\n";
            $output_data .= 'END:VCALENDAR';
        }

        $filename = md5($output_data . '|' . time());
        $filenamesvg = $filename . '.svg';
        $basename = basename($filenamesvg, '.svg');

        $codemargin = $outerframe !== 'none' ? $frames[$outerframe]['frame_border'] * 2 + 1 : 2;
        $content = \QRcdr::svg($output_data, false, $errorCorrectionLevel, $matrixPointSize, $codemargin, false, $backcolor, $frontcolor, $optionstyle);

        $svgfonts = (substr($labelFont, -4) === '.svg');

        $result = array(
            'basename' => $basename,
            'content' => $content,
            // 'nopdf' => false,
            // 'svgfonts' => true,
            // 'data' => $output_data,
        );
        $result = json_encode($result);

        echo $content;
    }

    public static function generateTicketQR($tokens)
    {
        require_once __DIR__ . '/lib/phpqrcode.php';
        require_once __DIR__ . '/lib/class-qrcdr.php';

        $output_data = false;

        $backcolor = 0xFFFFFF;
        $frontcolor = 0x000000;
        $gradient_color = '#8900d5';
        $pattern = 'circle';
        $markerOut = 'rounded';
        $markerIn = 'circle';
        $markerOutColor = "#000000";
        $markerInColor = "#000000";
        $marker_top_right_outline = "#000000";
        $marker_top_right_center = "#000000";
        $marker_bottom_left_outline = "#000000";
        $marker_bottom_left_center = "#000000";
        $optionLogo = 'none';
        $logoSize = 100;
        $frameColor = '#000000';
        $frameLabel = 'SCAN ME';
        $labelFont = 'AbrilFatface.svg';
        $labelTextSize = '100';
        $labelTextColor = '#ffffff';
        $outerframe = 'none';
        $size = 32;
        $level = 'Q';
        $errorCorrectionLevel = 2;
        $matrixPointSize = min(max((int) $size, 4), 32);

        $optionstyle = array(
            'optionlogo' => $optionLogo,
            'pattern' => $pattern,
            'marker_out' => $markerOut,
            'marker_in' => $markerIn,
            'marker_out_color' => $markerOutColor,
            'marker_in_color' => $markerInColor,
            'marker_top_right_outline' => $marker_top_right_outline,
            'marker_top_right_center' => $marker_top_right_center,
            'marker_bottom_left_outline' => $marker_bottom_left_outline,
            'marker_bottom_left_center' => $marker_bottom_left_center,
            'gradient' => false,
            'gradient_color' => $gradient_color,
            'markers_color' => false,
            'radial' => false,
            'no_logo_bg' => true,
            'frame' => 'none',
            'custom_frame_color' => false,
            'framecolor' => $frameColor,
            'framelabel' => $frameLabel,
            'label_font' => $labelFont,
            'labeltext_color' => $labelTextColor,
            'logo_size' => $logoSize,
            'label_text_size' => $labelTextSize,
            'transparent_code' => false,
            'bg_image' => 'none',
            'negative' => false,
        );

        $frames = array(
            'none' => array(
                'path' => '<polygon points="18.7,6.6 12,13.3 5.3,6.6 4.6,7.3 11.3,14 4.6,20.7 5.3,21.4 12,14.7 18.7,21.4 19.4,20.7 12.7,14 19.4,7.3 "/>',
            ),
            'bottom' => array(
                'path' => '<path d="M22.7,0H1.3C0.6,0,0,0.6,0,1.3v25.3C0,27.4,0.6,28,1.3,28h21.3c0.7,0,1.3-0.6,1.3-1.3V1.3C24,0.6,23.4,0,22.7,0 z M23,22c0,0.6-0.5,1-1,1H2c-0.6,0-1-0.5-1-1V2c0-0.6,0.5-1,1-1h20c0.6,0,1,0.5,1,1V22z"/>',
                'label_pos' => 'bottom',
                'label_size' => 3,
                'label_offset' => 0,
                'frame_border' => 1,
            ),
            'top' => array(
                'path' => '<path d="M1.3,28L22.6,28c0.7,0,1.3-0.6,1.3-1.3L24,1.4c0-0.7-0.6-1.3-1.3-1.3L1.4,0C0.7,0,0.1,0.6,0,1.3L0,26.6 C-0.1,27.4,0.5,28,1.3,28z M1,6c0-0.6,0.5-1,1-1L22,5c0.6,0,1,0.5,1,1L23,26c0,0.6-0.5,1-1,1L2,27c-0.6,0-1-0.5-1-1L1,6z"/>',
                'label_pos' => 'top',
                'label_size' => 3,
                'label_offset' => 0,
                'frame_border' => 1,
            ),
            'balloon-bottom' => array(
                'path' => '<path d="M1.3,24l21.3,0c0.7,0,1.3-0.6,1.3-1.3l0-21.3C24,0.6,23.4,0,22.7,0L1.3,0C0.6,0,0,0.6,0,1.3l0,21.3 C0,23.4,0.6,24,1.3,24z M1,2c0-0.6,0.5-1,1-1l20,0c0.6,0,1,0.5,1,1v20c0,0.6-0.5,1-1,1L2,23c-0.6,0-1-0.5-1-1V2z"/><path d="M1,30h22c0.5,0,1-0.4,1-1v-3c0-0.5-0.4-1-1-1H13l-1-1l-1,1H1c-0.5,0-1,0.4-1,1v3C0,29.6,0.4,30,1,30z"/>',
                'label_pos' => 'bottom',
                'label_size' => 3,
                'label_offset' => 2,
                'frame_border' => 1,
            ),
            'balloon-top' => array(
                'path' => '<path d="M22.7,6L1.3,6C0.6,6,0,6.6,0,7.3l0,21.3C0,29.4,0.6,30,1.3,30l21.3,0c0.7,0,1.3-0.6,1.3-1.3l0-21.3 C24,6.6,23.4,6,22.7,6z M23,28c0,0.6-0.5,1-1,1L2,29c-0.6,0-1-0.5-1-1V8c0-0.6,0.5-1,1-1l20,0c0.6,0,1,0.5,1,1V28z"/><path d="M23,0H1C0.4,0,0,0.4,0,1v3c0,0.5,0.4,1,1,1h10l1,1l1-1h10c0.5,0,1-0.4,1-1V1C24,0.4,23.6,0,23,0z"/>',
                'label_pos' => 'top',
                'label_size' => 3,
                'label_offset' => 2,
                'frame_border' => 1,
            ),
            'ribbon-bottom' => array(
                'path' => '<path d="M24,21h-1.7V1.7H1.7V21H0l1,2l-1,2h1v2h22v-2h1l-1-2L24,21z M2,2h20v19v1H2v-1V2z"/>',
                'label_pos' => 'bottom',
                'label_size' => 3,
                'label_offset' => -1,
                'frame_border' => 2,
            ),
            'ribbon-top' => array(
                'path' => '<path d="M0,6h1.7v19.3h20.7V6H24l-1-2l1-2h-1V0H1v2H0l1,2L0,6z M22,25H2V6V5h20v1V25z"/>',
                'label_pos' => 'top',
                'label_size' => 3,
                'label_offset' => -1,
                'frame_border' => 2,
            ),
            'phone' => array(
                'path' => '<path d="M17.6,0H6.4c-1,0-1.8,0.8-1.8,1.8v20.4c0,1,0.8,1.8,1.8,1.8h11.1c1,0,1.8-0.8,1.8-1.8V1.8C19.4,0.8,18.6,0,17.6,0z M11.2,2.3h2.7c0.1,0,0.2,0.1,0.2,0.2S14,2.7,13.9,2.7h-2.7c-0.1,0-0.2-0.1-0.2-0.2S11.1,2.3,11.2,2.3z M10.1,2.3 c0.1,0,0.2,0.1,0.2,0.2s-0.1,0.2-0.2,0.2c-0.1,0-0.2-0.1-0.2-0.2S10,2.3,10.1,2.3z M19,19H5V5h14V19z"/>',
                'label_pos' => 'bottom',
                'label_size' => 4,
                'label_offset' => -4.5,
                'frame_border' => 5,
            ),
            'cine' => array(
                'path' => '<path d="M4.5,4.5L4.5,4.5L4.5,4.5l0,17.2c0,0.3,0.3,0.6,0.6,0.6h13.8c0.3,0,0.6-0.3,0.6-0.6V4.5H4.5z M19,18.6
        c0,0.2-0.2,0.4-0.4,0.4H5.4C5.2,19,5,18.8,5,18.6V5.4C5,5.2,5.2,5,5.4,5h13.1C18.8,5,19,5.2,19,5.4V18.6z"/><path d="M19.1,0.1L4.2,1.7l0.3,2.8l14.9-1.6L19.1,0.1z M6.8,3.8L4.9,4l1.7-2.1l1.9-0.2L6.8,3.8z M10.5,3.4L8.6,3.6l1.7-2.1l1.9-0.2 L10.5,3.4z M14.2,3l-1.9,0.2L14,1.1l1.9-0.2L14.2,3z M18,2.6l-1.9,0.2l1.7-2.1l0.9-0.1l0.1,0.9L18,2.6z"/>',
                'label_pos' => 'bottom',
                'label_size' => 2.5,
                'label_offset' => -4.6,
                'frame_border' => 5,
            ),
        );


        $ticket_token = generate_ticket_token($tokens[0], $tokens[1], $tokens[2]);
        $base_url = url('/');

        $base_url .= '/check-ticket';
        $base_url .= '?ref=' . $ticket_token;
        $base_url .= '&_token=' . generate_random_string(21);

        $output_data = $base_url;

        $filename = md5($output_data . '|' . time());
        $filenamesvg = $filename . '.svg';
        $basename = basename($filenamesvg, '.svg');

        $codemargin = $outerframe !== 'none' ? $frames[$outerframe]['frame_border'] * 2 + 1 : 2;
        $content = \QRcdr::svg($output_data, false, $errorCorrectionLevel, $matrixPointSize, $codemargin, false, $backcolor, $frontcolor, $optionstyle);

        $svgfonts = (substr($labelFont, -4) === '.svg');

        $result = array(
            'basename' => $basename,
            'content' => $content,
            // 'nopdf' => false,
            // 'svgfonts' => true,
            // 'data' => $output_data,
        );
        $result = json_encode($result);

        echo $content;
        die;
    }
}
