@extends('frontend.layouts.app')
@php
$coupon_code = null;
$coupon_discount = 0;
@endphp

@foreach ($carts as $key => $cartItem)
@if ($cartItem->coupon_applied == 1)
@php
$coupon_code = $cartItem->coupon_code;
break;
@endphp
@endif
@endforeach

@php
$coupon_discount = optional($carts)->sum('discount');
@endphp
@section('content')
<div id="cart-page-wrapper">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <ul
                    class="product-breadcrumb breadcrumb justify-content-center justify-content-lg-start bg-transparent p-0">
                    <li class="breadcrumb-item has-transition opacity-60 hov-opacity-100">
                        <a class="text-reset" href="{{ route('home') }}">{{ translate('Home') }}</a>
                    </li>
                    <li class="text-dark fw-600 breadcrumb-item">
                        <span>{{ translate('Cart') }}</span>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="row bg-white mb-4 rowcartresp">
            @if (isset($carts) && count($carts) > 0)
            @php
            $total = 0;
            @endphp

            <div class="col-md-9">
                <div class="cart-table-content">
                    <div class="row table-head">
                        <div class="col-md-5">
                            {{ translate('Offer') }}
                        </div>
                        <div class="col-md-3">
                            {{ translate('Quantity') }}
                        </div>
                        <div class="col-md-3">
                            {{ translate('Total') }}
                        </div>
                        <div class="col-md-1"></div>
                    </div>

                    @foreach ($carts as $key => $cartItem)
                    @php
                    $product = get_single_product($cartItem['product_id']);
                    $product_stock = $product->stocks->where('variant', $cartItem->variation)->first();

                    $total = $total + cart_product_price($cartItem, $product, false) * $cartItem->quantity;
                    @endphp

                    @if (null != $product)
                    <div class="row">
                        <div class="col-md-5">
                            <div class="d-flex">
                                <div>
                                    <img src="{{ static_asset('assets/img/placeholder.jpg') }}"
                                        data-src="{{ uploaded_asset($product->thumbnail_img) }}"
                                        class="img-fit lazyload size-60px has-transition"
                                        alt="{{ $product->getTranslation('name') }}"
                                        onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';">
                                </div>
                                <div>
                                    <span class="cart-product-name">{{ $product->getTranslation('name') }}</span><br>
                                    <span class="cart-product-price">{!! cart_product_price($cartItem, $product)
                                        !!}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="d-flex align-items-center crea-plus-minus mr-0 ml-0">
                                <button class="btn col-auto btn-icon btn-sm btn-light rounded-0" type="button"
                                    data-type="minus" data-field="quantity[{{ $cartItem->id }}]">
                                    <i class="las la-minus"></i>
                                </button>
                                <input type="number" name="quantity[{{ $cartItem->id }}]"
                                    class="col border-0 text-center px-0 fs-14 input-number qty-input" placeholder="1"
                                    value="{{ $cartItem['quantity'] }}" min="{{ $product->min_qty }}"
                                    max="{{ $product_stock->qty }}" data-cart-item="{{ $cartItem->id }}"
                                    style="min-width: 45px;">
                                <button class="btn col-auto btn-icon btn-sm btn-light rounded-0" type="button"
                                    data-type="plus" data-field="quantity[{{ $cartItem->id }}]">
                                    <i class="las la-plus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <span class="cart-product-total">
                                {!! single_price(cart_product_price($cartItem, $product, false) * $cartItem->quantity)
                                !!}
                            </span>
                        </div>
                        <div class="col-md-1">
                            <a href="javascript:void(0)" onclick="removeFromCartView(event, {{ $cartItem->id }})"
                                class="btn btn-icon btn-sm bg-white hov-svg-danger" title="{{ translate('Remove') }}">
                                <svg xmlns="http://www.w3.org/2000/svg" width="12.27" height="16"
                                    viewBox="0 0 12.27 16">
                                    <g id="Group_23970" data-name="Group 23970" transform="translate(-1332 -420)">
                                        <path id="Path_28714" data-name="Path 28714"
                                            d="M17.9,9.037l-.258,7.8a2.569,2.569,0,0,1-2.577,2.485h-4.9A2.569,2.569,0,0,1,7.587,16.84l-.258-7.8a.645.645,0,0,1,1.289-.043l.258,7.8a1.289,1.289,0,0,0,1.289,1.239h4.9a1.289,1.289,0,0,0,1.289-1.241l.258-7.8a.645.645,0,0,1,1.289.043Zm.852-2.6a.644.644,0,0,1-.644.644H7.122a.644.644,0,1,1,0-1.289h2a.822.822,0,0,0,.82-.74,1.927,1.927,0,0,1,1.922-1.736h1.5a1.927,1.927,0,0,1,1.922,1.736.822.822,0,0,0,.82.74h2a.644.644,0,0,1,.644.644ZM11.058,5.8h3.11A2.126,2.126,0,0,1,14,5.189a.644.644,0,0,0-.64-.58h-1.5a.644.644,0,0,0-.64.58,2.126,2.126,0,0,1-.165.608Zm.649,9.761V10.072a.644.644,0,0,0-1.289,0v5.488a.644.644,0,0,0,1.289,0Zm3.1,0V10.072a.644.644,0,1,0-1.289,0v5.488a.644.644,0,1,0,1.289,0Z"
                                            transform="translate(1325.522 416.678)" fill="#9d9da6" />
                                    </g>
                                </svg>
                            </a>
                        </div>
                    </div>
                    @endif
                    @endforeach
                </div>

                <div class="d-flex cartholderbtn justify-content-end">
                    <div>
                        <a class="btn btn-warning" id="continuebtn" href="{{ route('home') }}">{{ translate('Continue
                            shopping') }}</a>
                    </div>
                    <div class="d-flex">

                        <div>
                            <button id="delete-cart-btn" class="btn btn-warning">{{ translate('Delete all') }}</button>
                        </div>
                        <div>
                            <button id="update-cart-btn" class="btn btn-warning">{{ translate('Update Cart') }}</button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3 bg-gris">
                <div class="cart-summary-wrapper">
                    <div class="cart-summary-header">
                        <span>{{ translate('Cart Total') }}</span>
                    </div>
                    <div class="cart-summary-content">
                        <div class="d-flex justify-content-between">
                            <span><strong>{{ translate('Total') }}</strong></span>
                            <span class="carttotalprix">{!! single_price($total) !!}</span>
                        </div>

                        <div class="cart-coupon">
                            <div class="coupon-title">{{ translate('Coupon') }}</div>
                            <div class="coupon-desc">{{ translate('Le code promo fonctionnera sur la page de paiement.')
                                }}</div>
                            @if ($coupon_discount > 0 && $coupon_code)
                            <div class="mt-3">
                                <form class="" id="remove-coupon-form" enctype="multipart/form-data">
                                    @csrf
                                    <div class="input-group">
                                        <div class="form-control">{{ $coupon_code }}</div>
                                        <div class="input-group-append">
                                            <button type="button" id="coupon-remove" class="btn btn-primary">{{
                                                translate('Remove Coupon') }}</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            @else
                            <div class="mt-3">
                                <form class="" id="apply-coupon-form" enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="owner_id" value="{{ $carts[0]['owner_id'] }}">
                                    <div class="input-group">
                                        <input type="text" class="form-control rounded-0" name="code"
                                            onkeydown="return event.key != 'Enter';"
                                            placeholder="{{ translate('Have coupon code? Apply here') }}" required>
                                        <div class="input-group-append">
                                            <button type="button" id="coupon-apply" class="btn btn-primary rounded-0">{{
                                                translate('Apply') }}</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            @endif
                        </div>

                        <div class="cart-subtotal">
                            <span>{{ translate('Sub total') }}</span>

                            <span id="sub-total-value">{!! single_price($total - $coupon_discount) !!}</span>
                        </div>
                    </div>
                    <div class="cart-summary-footer">
                        <a class="btn btn-warning" href="{{ route('checkout') }}">{{ translate('Confirm my order')
                            }}</a>
                    </div>
                </div>
            </div>
            @else


            <div class="m-auto text-center py-4 not-found">
                <img src="{{ static_asset('assets/img/empty-cart.webp') }}">
                <h2>{{ translate('Oops... Your cart is empty!') }}</h2>
                <p>{{ translate('You haven\'t added anything to your cart yet... but don\'t rush off!')
                    }}</p>
                <p>{{ translate('There are lots of incredible offers and events waiting for you.') }}
                </p>

                <div class="row grayrow">
                    <div class="col-md-5">
                        <div class="info-box">
                            <img src="{{ static_asset('assets/img/add-to-cart.png') }}" alt="">
                            <span> {{ translate('Add your favorite items and complete your order with simplicity.') }}
                            </span>
                        </div>
                    </div>
                    <div class="col-md-2"><img src="{{ static_asset('assets/img/ou.webp')}}"></div>
                    <div class="col-md-5">
                        <div class="info-box">
                            <img src="{{ static_asset('assets/img/promotions-special-offers.webp')}}">
                            <span> {{ translate('Discover') }} <a href="{{ route('search', ['promotion' => 1]) }}">{{
                                    translate('our promotions and special offers') }}.</a></span>
                        </div>
                    </div>
                </div>

            </div>

            @endif
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
    function removeFromCartView(e, key) {
        e.preventDefault();
        $.post('{{ route('cart.removeFromCart') }}', {
            _token: CREA.data.csrf,
            id: key
        }, function (data) {
            window.location.reload();
        });
    }

    function updateQuantityFromCartView(key, element, callback) {
        $.post('{{ route('cart.updateQuantity') }}', {
            _token: CREA.data.csrf,
            id: key,
            quantity: element.value
        }, function (data) {
            if (callback) {
                callback();
            }
        });
    }

    $(document).ready(function () {

        // update cart
        $(document).on('click', '#update-cart-btn', function () {
            const qty_inputs = $('.qty-input');
            let completedRequests = 0; // Counter to track completed requests

            $.each(qty_inputs, function (index, element) {
                const itemKey = $(element).data('cart-item');
                updateQuantityFromCartView(itemKey, element, function () {
                    // Increment the counter when a request is completed
                    completedRequests++;

                    // Check if all requests are completed
                    if (completedRequests === qty_inputs.length) {
                        window.location.reload();
                    }
                });
            });
        });


        $(document).on('click', '#delete-cart-btn', function () {
            const qty_inputs = $('.qty-input');
            let completedRequests = 0;  // Counter to track completed requests

            $.each(qty_inputs, function (index, element) {
                const itemKey = $(element).data('cart-item');
                $.post('{{ route('cart.removeFromCart') }}', {
                    _token: CREA.data.csrf,
                    id: itemKey
                }, function (data) {
                    // Increment the counter when a request is completed
                    completedRequests++;

                    // Check if all requests are completed
                    if (completedRequests === qty_inputs.length) {
                        window.location.reload();
                    }
                });
            });
        });


        // coupon apply
        $(document).on("click", "#coupon-apply", function () {
            var data = new FormData($('#apply-coupon-form')[0]);
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                method: "POST",
                url: "{{ route('checkout.apply_coupon_code') }}",
                data: data,
                cache: false,
                contentType: false,
                processData: false,
                success: function (data, textStatus, jqXHR) {
                    window.location.reload();
                }
            });
        });

        // coupon remove
        $(document).on("click", "#coupon-remove", function () {
            @if (Auth:: check() && Auth:: user() -> user_type == 'customer')
        var data = new FormData($('#remove-coupon-form')[0]);
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            method: "POST",
            url: "{{ route('checkout.remove_coupon_code') }}",
            data: data,
            cache: false,
            contentType: false,
            processData: false,
            success: function (data, textStatus, jqXHR) {
                window.location.reload();
            }
        });
        @endif
    });
        });
</script>
@endsection