@extends('frontend.layouts.app')
@section('content')
    {{-- Featured Categories --}}
    @if (count($featured_categories) > 0)
        <section class="categories-sec">
            <div class="container">
                <!-- Categories -->
                <div>
                    <div class="d-flex">
                        <div class=" px-0 cat-item first-item-cat">
                            <div class=" text-center ">
                                <div class="px-0">
                                    <span class="text-dark mb-0  text-truncate-2">
                                        <a href="{{ url('/search?sort_by=newest') }}" title="New in">
                                            {{ translate('NEW IN') }}
                                        </a>
                                    </span>
                                </div>
                            </div>
                        </div>
                        @foreach ($featured_categories->take(7) as $key => $category)
                            @php
                                $category_name = $category->getTranslation('name');
                            @endphp
                            <div class=" px-0 cat-item ">
                                <div class=" itemhold text-center ">
                                    <div>
                                        <a href="{{ route('products.category', $category->slug) }}"
                                            title="{{ $category_name }}"> <img
                                                src="{{ isset($category->bannerImage->file_name) ? my_asset($category->bannerImage->file_name) : static_asset('assets/img/placeholder.jpg') }}"
                                                class="lazyload h-auto mx-auto has-transition"
                                                alt="{{ $category->getTranslation('name') }}"
                                                onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';"></a>
                                    </div>
                                    <div class="px-0">
                                        <span class="text-dark mb-0 text-truncate-2">
                                            <a href="{{ route('products.category', $category->slug) }}"
                                                title="{{ $category_name }}">
                                                {{ $category_name }}

                                                @if (count($category->childrenCategories) > 0)
                                                    <span class="children-toggle"></span>
                                                @endif
                                            </a>
                                        </span>
                                    </div>
                                    <ul class="holdermenu-above">
                                        @foreach ($category->childrenCategories->take(6) as $key => $child_category)
                                            <li class="itemmenu-above"> <a
                                                    href="{{ route('products.category', $child_category->slug) }}"
                                                    class="text-center text-light">
                                                    {{ $child_category->getTranslation('name') }}
                                                </a>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </section>
    @endif

    <section class="my-4 gry-bg">
        <div class="container">
            <form class="form-default" data-toggle="validator" action="{{ route('payment.checkout') }}" role="form"
                method="POST" id="checkout-form">
                @csrf
                <div class="row cols-xs-space cols-sm-space cols-md-space">
                    <div class="col-lg-8 mx-auto">
                        <div class="accordion" id="accordioncCheckoutInfo">
                            @guest
                                <div class="row">
                                    <div class="col-md-6">
                                        <input type="radio" name="type_account" id="as_guest" class="d-none" value="as_guest"
                                            checked>
                                        <label for="as_guest" type="button" onclick="complete_as_guest()"
                                            class="btn btn-primary btn-block">{{ translate('Complete as guest') }}</button>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="radio" name="type_account" id="with_account" class="d-none"
                                            value="with_account">
                                        <label for="with_account" type="button" onclick="complete_with_account()"
                                            class="btn btn-primary btn-block">{{ translate('With account') }}</button>
                                    </div>
                                </div>

                                <div class="guest-form card rounded-0 border shadow-none">
                                    <div class="card-header border-bottom-0 py-3 py-xl-4" id="headingAccountInfo" type="button"
                                        data-toggle="collapse" data-target="#collapseAccountInfo" aria-expanded="true"
                                        aria-controls="collapseAccountInfo">
                                        <div class="d-flex align-items-center">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                                viewBox="0 0 20 20">
                                                <path id="Path_42357" data-name="Path 42357"
                                                    d="M58,48A10,10,0,1,0,68,58,10,10,0,0,0,58,48ZM56.457,61.543a.663.663,0,0,1-.423.212.693.693,0,0,1-.428-.216l-2.692-2.692.856-.856,2.269,2.269,6-6.043.841.87Z"
                                                    transform="translate(-48 -48)" fill="#9d9da6" />
                                            </svg>
                                        </div>
                                        <i class="las la-angle-down fs-18"></i>
                                    </div>

                                    <div id="collapseAccountInfo" class="collapse show" aria-labelledby="headingAccountInfo"
                                        data-parent="#accordioncCheckoutInfo">
                                        <div class="container">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="first_name">{{ translate('First Name') }} *</label>
                                                        <input type="text" class="form-control" name="first_name"
                                                            id="first_name" value="{{ old('first_name') }}">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="last_name">{{ translate('Last Name') }} *</label>
                                                        <input type="text" class="form-control" name="last_name"
                                                            id="last_name" value="{{ old('last_name') }}">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="email">{{ translate('Email') }} *</label>
                                                        <input type="email" class="form-control" name="email"
                                                            id="email" value="{{ old('email') }}">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label for="phone">{{ translate('Phone') }} *</label>
                                                        <input type="tel" class="form-control" name="phone"
                                                            id="phone" value="{{ old('phone') }}">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endguest

                            <!-- Delivery Info -->
                            <div class="card rounded-0 border shadow-none"
                                style="margin-bottom: 2rem; overflow: visible !important;">
                                <div class="card-header border-bottom-0 py-3 py-xl-4" id="headingDeliveryInfo"
                                    type="button" data-toggle="collapse" data-target="#collapseDeliveryInfo"
                                    aria-expanded="true" aria-controls="collapseDeliveryInfo">
                                    <div class="d-flex align-items-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                            viewBox="0 0 20 20">
                                            <path id="Path_42357" data-name="Path 42357"
                                                d="M58,48A10,10,0,1,0,68,58,10,10,0,0,0,58,48ZM56.457,61.543a.663.663,0,0,1-.423.212.693.693,0,0,1-.428-.216l-2.692-2.692.856-.856,2.269,2.269,6-6.043.841.87Z"
                                                transform="translate(-48 -48)" fill="#9d9da6" />
                                        </svg>
                                        <span class="ml-2 fs-19 fw-700">{{ translate('Cart') }}</span>
                                    </div>
                                    <i class="las la-angle-down fs-18"></i>
                                </div>
                                <div id="collapseDeliveryInfo" class="collapse show"
                                    aria-labelledby="headingDeliveryInfo" data-parent="#accordioncCheckoutInfo">
                                    <div class="card-body cart-details" id="cart-details">
                                        {{-- @include('frontend.partials.cart.delivery_info', [
                                            'carts' => $carts,
                                            'carrier_list' => $carrier_list,
                                            'shipping_info' => $shipping_info,
                                        ]) --}}

                                        @include('frontend.partials.cart.cart_details', [
                                            'carts' => $carts,
                                        ])
                                    </div>
                                </div>
                            </div>

                            {{-- Payment Info --}}
                            <div class="card rounded-0 mb-0 border shadow-none">
                                <div class="card-header border-bottom-0 py-3 py-xl-4" id="headingPaymentInfo"
                                    type="button" data-toggle="collapse" data-target="#collapsePaymentInfo"
                                    aria-expanded="true" aria-controls="collapsePaymentInfo">
                                    <div class="d-flex align-items-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                            viewBox="0 0 20 20">
                                            <path id="Path_42357" data-name="Path 42357"
                                                d="M58,48A10,10,0,1,0,68,58,10,10,0,0,0,58,48ZM56.457,61.543a.663.663,0,0,1-.423.212.693.693,0,0,1-.428-.216l-2.692-2.692.856-.856,2.269,2.269,6-6.043.841.87Z"
                                                transform="translate(-48 -48)" fill="#9d9da6" />
                                        </svg>
                                        <span class="ml-2 fs-19 fw-700">{{ translate('Payment') }}</span>
                                    </div>
                                    <i class="las la-angle-down fs-18"></i>
                                </div>
                                <div id="collapsePaymentInfo" class="collapse show" aria-labelledby="headingPaymentInfo"
                                    data-parent="#accordioncCheckoutInfo">
                                    <div class="card-body" id="payment_info">
                                        @include('frontend.partials.cart.payment_info', [
                                            'carts' => $carts,
                                            'total' => $total,
                                        ])
                                        <!-- Agree Box -->
                                        {{-- <div class="pt-2rem fs-14">
                                            <label class="crea-checkbox">
                                                <input type="checkbox" required id="agree_checkbox"
                                                    onchange="stepCompletionPaymentInfo()">
                                                <span class="crea-square-check"></span>
                                                <span>{{ translate('I agree to the') }}</span>
                                            </label>
                                            <a href="{{ route('terms') }}"
                                                class="fw-700">{{ translate('Terms and conditions') }}</a>,
                                            <a href="{{ route('returnpolicy') }}"
                                                class="fw-700">{{ translate('Return policy') }}</a> &
                                            <a href="{{ route('privacypolicy') }}"
                                                class="fw-700">{{ translate('Privacy policy') }}</a>
                                        </div> --}}
                                        {{-- <div class="row align-items-center pt-3 mb-4">
                                            <!-- Return to shop -->
                                            <div class="col-6">
                                                <a href="{{ route('home') }}" class="btn btn-link fs-14 fw-700 px-0">
                                                    <i class="las la-arrow-left fs-16"></i>
                                                    {{ translate('Return to shop') }}
                                                </a>
                                            </div>
                                            <!-- Complete Order -->
                                            <div class="col-6 text-right">
                                                <button type="button"
                                                    onclick="@guest showAccountModal() @else submitOrder(this) @endguest"
                                                    id="submitOrderBtn"
                                                    class="btn btn-primary fs-14 fw-700 rounded-0 px-4">{{ translate('Complete Order') }}</button>
                                            </div>
                                        </div> --}}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Cart Summary -->
                    <div class="col-lg-4 mt-4 mt-lg-0" id="cart_summary">
                        @include('frontend.partials.cart.cart_summary', [
                            'proceed' => 0,
                            'carts' => $carts,
                        ])
                    </div>
                </div>
            </form>
        </div>
    </section>
@endsection
@section('modal')
    <!-- Address Modal -->
    {{-- @if (Auth::check())
        @include('frontend.partials.address.address_modal')
    @endif --}}

    <div id="cart-update-modal" class="modal fade">
        <div class="modal-dialog modal-sm modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                </div>
                <div class="modal-body text-center">
                    <img src="{{ url('/public/assets/img/check.webp') }}" width="75" alt="">
                    <p class="mt-1 fs-14">{{ translate('Cart has been updated successfully') }}</p>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script type="text/javascript">
        function removeFromCartView(e, key) {
            e.preventDefault();
            // removeFromCart(key);

            $.post('{{ route('cart.removeFromCart') }}', {
                _token: CREA.data.csrf,
                id: key
            }, function(data) {
                updateNavCart(data.nav_cart_view, data.cart_count);
                $('#cart-details').html(data.cart_view);
                CREA.plugins.notify('success', "{{ translate('Item has been removed from cart') }}");
                $('#cart_items_sidenav').html(parseInt($('#cart_items_sidenav').html()) - 1);

                $('#cart-update-modal').modal();
CREA.extra.plusMinus();


                if (1 > data.cart_count) {
                    setTimeout(function() {
                        window.location.href = '{{ url('/') }}';
                    }, 3000);
                }
            });
        }

        

        $(document).ready(function() {
            $(".online_payment").click(function() {
                $('#manual_payment_description').parent().addClass('d-none');
            });
            toggleManualPaymentData($('input[name=payment_option]:checked').data('id'));
        });
        var minimum_order_amount_check = {{ get_setting('minimum_order_amount_check') == 1 ? 1 : 0 }};
        var minimum_order_amount =
            {{ get_setting('minimum_order_amount_check') == 1 ? get_setting('minimum_order_amount') : 0 }};

        function complete_as_guest() {
            $('.guest-form').removeClass('d-none');
        }

        function complete_with_account() {
            $('.guest-form').addClass('d-none');
        }

        function use_wallet() {
            $('input[name=payment_option]').val('wallet');
            if ($('#agree_checkbox').is(":checked")) {
                ;
                if (minimum_order_amount_check && $('#sub_total').val() < minimum_order_amount) {
                    CREA.plugins.notify('danger',
                        '{{ translate('You order amount is less then the minimum order amount') }}');
                } else {
                    var allIsOk = false;
                    var isOkShipping = stepCompletionShippingInfo();
                    var isOkDelivery = stepCompletionDeliveryInfo();
                    var isOkPayment = stepCompletionWalletPaymentInfo();
                    if (isOkShipping && isOkDelivery && isOkPayment) {
                        allIsOk = true;
                    } else {
                        CREA.plugins.notify('danger', '{{ translate('Please fill in all mandatory fields!') }}');
                        $('#checkout-form [required]').each(function(i, el) {
                            if ($(el).val() == '' || $(el).val() == undefined) {
                                var is_trx_id = $('.d-none #trx_id').length;
                                if (($(el).attr('name') != 'trx_id') || is_trx_id == 0) {
                                    $(el).focus();
                                    $(el).scrollIntoView({
                                        behavior: "smooth",
                                        block: "center"
                                    });
                                    return false;
                                }
                            }
                        });
                    }
                    if (allIsOk) {
                        $('#checkout-form').submit();
                    }
                }
            } else {
                CREA.plugins.notify('danger', '{{ translate('You need to agree with our policies') }}');
            }
        }

        function submitOrder(el) {
            let type_account = undefined;

            if ($('[name="type_account"]')) {
                type_account = $('[name="type_account"]:checked').val();
            }

            stepCompletionAccountInfo();

            $(el).prop('disabled', true);
            if ($('#agree_checkbox').is(":checked")) {
                if (minimum_order_amount_check && $('#sub_total').val() < minimum_order_amount) {
                    CREA.plugins.notify('danger',
                        '{{ translate('You order amount is less then the minimum order amount') }}');
                } else {
                    var offline_payment_active = '{{ addon_is_activated('offline_payment') }}';
                    if (offline_payment_active == '1' &&
                        $('.offline_payment_option').is(":checked") && $('#trx_id').val() == '') {
                        CREA.plugins.notify('danger', '{{ translate('You need to put Transaction id') }}');
                        $(el).prop('disabled', false);
                    } else {
                        var allIsOk = false;
                        // var isOkShipping = stepCompletionShippingInfo();
                        var isOkAccount = stepCompletionAccountInfo();
                        var isOkDelivery = stepCompletionDeliveryInfo();
                        var isOkPayment = stepCompletionPaymentInfo();
                        if (
                            // isOkShipping && 
                            isOkAccount &&
                            isOkDelivery &&
                            isOkPayment
                        ) {
                            allIsOk = true;
                        } else {
                            CREA.plugins.notify('danger', '{{ translate('Please fill in all mandatory fields!') }}');
                            $('#checkout-form [required]').each(function(i, el) {
                                if ($(el).val() == '' || $(el).val() == undefined) {
                                    var is_trx_id = $('.d-none #trx_id').length;
                                    if (($(el).attr('name') != 'trx_id') || is_trx_id == 0) {
                                        $(el).focus();
                                        $(el).scrollIntoView({
                                            behavior: "smooth",
                                            block: "center"
                                        });
                                        return false;
                                    }
                                }
                            });
                        }
                        if (allIsOk) {
                            $('#checkout-form').submit();
                        }
                    }
                }
            } else {
                CREA.plugins.notify('danger', '{{ translate('You need to agree with our policies') }}');
                $(el).prop('disabled', false);
            }
        }

        function showAccountModal() {
            $('#account_modal').modal('show');
        }

        function toggleManualPaymentData(id) {
            if (typeof id != 'undefined') {
                $('#manual_payment_description').parent().removeClass('d-none');
                $('#manual_payment_description').html($('#manual_payment_info_' + id).html());
            }
        }
        // coupon apply
        $(document).on("click", "#coupon-apply", function() {
            @if (Auth::check())
                @if (Auth::user()->user_type != 'customer')
                    CREA.plugins.notify('warning',
                        "{{ translate('Please Login as a customer to apply coupon code.') }}");
                    return false;
                @endif
                var data = new FormData($('#apply-coupon-form')[0]);
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    method: "POST",
                    url: "{{ route('checkout.apply_coupon_code') }}",
                    data: data,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(data, textStatus, jqXHR) {
                        CREA.plugins.notify(
                            data.response_message.response,
                            data.response_message.message);
                        $("#cart_summary").html(data.html);
                    }
                });
            @else
                $('#login_modal').modal('show');
            @endif
        });
        // coupon remove
        $(document).on("click", "#coupon-remove", function() {
            @if (Auth::check() && Auth::user()->user_type == 'customer')
                var data = new FormData($('#remove-coupon-form')[0]);
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    method: "POST",
                    url: "{{ route('checkout.remove_coupon_code') }}",
                    data: data,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(data, textStatus, jqXHR) {
                        $("#cart_summary").html(data);
                    }
                });
            @endif
        });

        function updateDeliveryAddress(id, city_id = 0) {
            $('.crea-refresh').addClass('active');
            $.post('{{ route('checkout.updateDeliveryAddress') }}', {
                _token: CREA.data.csrf,
                address_id: id,
                city_id: city_id
            }, function(data) {
                $('#delivery_info').html(data.delivery_info);
                $('#cart_summary').html(data.cart_summary);
                $('.crea-refresh').removeClass('active');
            });
            CREA.plugins.bootstrapSelect("refresh");
        }

        function stepCompletionAccountInfo() {
            var headColor = '#9d9da6';
            var btnDisable = false;
            var allOk = false;

            @if (Auth::check())
                headColor = '#15a405';
                btnDisable = false;
                allOk = true;
            @else
                if ($('[name="type_account"]')) {
                    const account_type = $('[name="type_account"]:checked').val();

                    if ('as_guest' == account_type) {
                        const first_name = $('[name="first_name"]').val();
                        const last_name = $('[name="last_name"]').val();
                        const email = $('[name="email"]').val();
                        const phone = $('[name="phone"]').val();

                        if (
                            '' == first_name.trim() ||
                            '' == last_name.trim() ||
                            '' == email.trim() ||
                            '' == phone.trim()
                        ) {
                            alert('{{ translate('Guest information are required') }}');
                        } else {
                            headColor = '#15a405';
                            btnDisable = false;
                            allOk = true;
                        }
                    } else {
                        showAccountModal();
                        return;
                    }
                }
            @endif

            $('#headingAccountInfo svg *').css('fill', headColor);
            $("#submitOrderBtn").prop('disabled', btnDisable);
            return allOk;
        }

        function stepCompletionShippingInfo() {
            var headColor = '#9d9da6';
            var btnDisable = false;
            var allOk = false;
            @if (Auth::check())
                var length = $('input[name="address_id"]:checked').length;
                if (length > 0) {
                    headColor = '#15a405';
                    btnDisable = false;
                    allOk = true;
                }
            @else
                var count = 0;
                var length = $('#shipping_info [required]').length;
                $('#shipping_info [required]').each(function(i, el) {
                    if ($(el).val() != '' && $(el).val() != undefined && $(el).val() != null) {
                        count += 1;
                    }
                });
                if (count == length) {
                    headColor = '#15a405';
                    btnDisable = false;
                    allOk = true;
                }
            @endif
            $('#headingShippingInfo svg *').css('fill', headColor);
            $("#submitOrderBtn").prop('disabled', btnDisable);
            return allOk;
        }



        $('#shipping_info [required]').each(function(i, el) {
            $(el).change(function() {
                if ($(el).attr('name') == 'address_id') {
                    updateDeliveryAddress($(el).val());
                }
                @if (get_setting('shipping_type') == 'area_wise_shipping')
                    if ($(el).attr('name') == 'city_id') {
                        let country_id = $('select[name="country_id"]').val();
                        let city_id = $(this).val();
                        updateDeliveryAddress(country_id, city_id);
                    }
                @endif
                stepCompletionShippingInfo();
            });
        });

        function stepCompletionDeliveryInfo() {
            var headColor = '#9d9da6';
            var btnDisable = false;
            var allOk = false;
            var content = $('#delivery_info [required]');
            if (content.length > 0) {
                var content_checked = $('#delivery_info [required]:checked');
                if (content_checked.length > 0) {
                    content_checked.each(function(i, el) {
                        allOk = false;
                        if ($(el).val() == 'carrier') {
                            var owner = $(el).attr('data-owner');
                            if ($('input[name=carrier_id_' + owner + ']:checked').length > 0) {
                                allOk = true;
                            }
                        } else if ($(el).val() == 'pickup_point') {
                            var owner = $(el).attr('data-owner');
                            if ($('select[name="pickup_point_id_' + owner + '"]').val() != '') {
                                allOk = true;
                            }
                        } else {
                            allOk = true;
                        }
                        if (allOk == false) {
                            return false;
                        }
                    });
                    if (allOk) {
                        headColor = '#15a405';
                        btnDisable = false;
                    }
                }
            } else {
                allOk = true
                headColor = '#15a405';
                btnDisable = false;
            }
            $('#headingDeliveryInfo svg *').css('fill', headColor);
            $("#submitOrderBtn").prop('disabled', btnDisable);
            return allOk;
        }

        function updateDeliveryInfo(shipping_type, type_id, user_id, country_id = 0, city_id = 0) {
            @if (get_setting('shipping_type') == 'area_wise_shipping' || get_setting('shipping_type') == 'carrier_wise_shipping')
                country_id = $('select[name="country_id"]').val() != null ? $('select[name="country_id"]').val() : 0;
                city_id = $('select[name="city_id"]').val() != null ? $('select[name="city_id"]').val() : 0;
            @endif
            $('.crea-refresh').addClass('active');
            $.post('{{ route('checkout.updateDeliveryInfo') }}', {
                _token: CREA.data.csrf,
                shipping_type: shipping_type,
                type_id: type_id,
                user_id: user_id,
                country_id: country_id,
                city_id: city_id
            }, function(data) {
                $('#cart_summary').html(data);
                stepCompletionDeliveryInfo();
                $('.crea-refresh').removeClass('active');
            });
            CREA.plugins.bootstrapSelect("refresh");
        }

        function show_pickup_point(el, user_id) {
            var type = $(el).val();
            var target = $(el).data('target');
            var type_id = null;
            if (type == 'home_delivery' || type == 'carrier') {
                if (!$(target).hasClass('d-none')) {
                    $(target).addClass('d-none');
                }
                $('.carrier_id_' + user_id).removeClass('d-none');
            } else {
                $(target).removeClass('d-none');
                $('.carrier_id_' + user_id).addClass('d-none');
            }
            if (type == 'carrier') {
                type_id = $('input[name=carrier_id_' + user_id + ']:checked').val();
            } else if (type == 'pickup_point') {
                type_id = $('select[name=pickup_point_id_' + user_id + ']').val();
            }
            updateDeliveryInfo(type, type_id, user_id);
        }

        function stepCompletionPaymentInfo() {
            var headColor = '#9d9da6';
            var btnDisable = false;
            var payment = false;
            var agree = false;
            var allOk = false;
            var length = $('input[name="payment_option"]:checked').length;
            if (length > 0) {
                if ($('input[name="payment_option"]:checked').hasClass('offline_payment_option')) {
                    if ($('#trx_id').val() != '' && $('#trx_id').val() != undefined && $('#trx_id').val() != null) {
                        payment = true;
                    }
                } else {
                    payment = true;
                }
                if ($('#agree_checkbox').is(":checked")) {
                    agree = true;
                }
                if (payment && agree) {
                    headColor = '#15a405';
                    btnDisable = false;
                    allOk = true;
                }
            }

            if ($('#agree_checkbox').is(":checked")) {
                agree = true;
            }
            allOk = agree;

            $('#headingPaymentInfo svg *').css('fill', headColor);
            $("#submitOrderBtn").prop('disabled', btnDisable);
            return allOk;
        }

        function stepCompletionWalletPaymentInfo() {
            var headColor = '#9d9da6';
            var btnDisable = true;
            var allOk = false;
            if ($('#agree_checkbox').is(":checked")) {
                headColor = '#15a405';
                btnDisable = false;
                allOk = true;
            }
            $('#headingPaymentInfo svg *').css('fill', headColor);
            $("#submitOrderBtn").prop('disabled', btnDisable);
            return allOk;
        }
        $('input[name="payment_option"]').change(function() {
            stepCompletionPaymentInfo();
        });
        $(document).ready(function() {
            stepCompletionShippingInfo();
            stepCompletionDeliveryInfo();
            stepCompletionPaymentInfo();
        });
    </script>
    @include('frontend.partials.address.address_js')
    @if (get_setting('google_map') == 1)
        @include('frontend.partials.google_map')
    @endif
@endsection
