@extends('frontend.layouts.app')

@php
$coupon_code = null;
$coupon_discount = 0;
@endphp

@foreach ($carts as $key => $cartItem)
@if ($cartItem->coupon_applied == 1)
@php
$coupon_code = $cartItem->coupon_code;
break;
@endphp
@endif
@endforeach

@php
$coupon_discount = $carts->sum('discount');
@endphp

@section('content')
<div id="checkout-page-wrapper">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <ul
                    class="product-breadcrumb breadcrumb align-items-baseline justify-content-center justify-content-lg-start bg-transparent p-0">
                    <li class="breadcrumb-item has-transition opacity-60 hov-opacity-100">
                        <a class="text-reset" href="{{ route('home') }}">{{ translate('Home') }}</a>
                    </li>
                    <li class="breadcrumb-item">
                        <span>{{ translate('Checkout') }}</span>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="row mb-4 row-reverse-mob">
            <div class="col-md-6 col-sm-12 bg-white">
                <form class="form-default" data-toggle="validator" action="{{ route('payment.checkout') }}" role="form"
                    method="POST" id="checkout-form">
                    @csrf

                    @guest
                    <div class="d-flex justify-content-center">
                        <div class="checkout-form-toggle" data-target="#visitor-form">{{ translate('Visitor') }}</div>
                        <div class="checkout-form-toggle" data-target="#account-form">
                            {{ translate('You already have an
                            account ?') }}
                        </div>
                    </div>
                    <input type="hidden" name="type_account" value="as_guest">
                    <div class="checkout-form" id="visitor-form">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <input placeholder="{{ translate('First Name') }} *" type="text"
                                        class="form-control" name="first_name" id="first_name"
                                        value="{{ old('first_name') }}">
                                    @error('first_name')
                                    <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <input type="text" class="form-control" placeholder="{{ translate('Last Name') }} *"
                                        name="last_name" id="last_name" value="{{ old('last_name') }}">
                                    @error('last_name')
                                    <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <input type="email" placeholder="{{ translate('Email') }} *" class="form-control"
                                        name="email" id="email" value="{{ old('email') }}">
                                    @error('email')
                                    <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <input placeholder="{{ translate('Phone') }} *" type="tel" class="form-control"
                                        name="phone" id="phone" value="{{ old('phone') }}">
                                    @error('phone')
                                    <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                    @endguest

                    <div class="row checkoutrow">
                        @foreach (get_activate_payment_methods() as $payment_method)
                        <div class="col-xl-3 col-md-6">
                            <label style="width: 100%;" class="d-flex checkout-payment-method d-block mb-3">
                                <input value="{{ $payment_method->name }}" class="online_payment" type="radio"
                                    name="payment_option" checked>
                                <div style="width: 100%;"
                                    class="d-flex align-items-center justify-content-between crea-megabox-elem rounded-0 ">
                                    <span>
                                        <img src="{{ static_asset('assets/img/payment/' . $payment_method->name . '.webp') }}"
                                            class="img-fit h-100">

                                        {{ translate('Pay by') }} {{ ('payzone' == $payment_method->name) ? translate('Card') : $payment_method->name }}
                                    </span>
                                </div>
                            </label>
                        </div>
                        @endforeach
                    </div>

                    <div>
                        <label class="d-flex align-items-start inputsholder">
                            <input id="privacy-policy-check" type="checkbox">
                            <div> <span>{{ translate('I agree with the terms and conditions') }}</span><br>
                                <small>
                                    {{ translate('Your information will be saved on our account. By continuing, you
                                    agree to
                                    the
                                    terms of use and accept the') }}
                                    <a href="{{ url('/Termes-et-Conditions-dutilisation') }}">
                                        {{ translate('privacy policy') }}.</a>
                                </small>
                            </div>
                        </label>

                        <label class="d-flex align-items-start inputsholder">

                            <input id="notify-by-email-check" type="checkbox">
                            <span>{{ translate('Send me news and offers by e-mail') }}</span>
                        </label>
                    </div>
                    <button type="button" id="checkout-pay-btn" class="btn btn-warning defbtn">{{ translate('Pay now')
                        }}</button>
                </form>
            </div>
            <div class="col-md-6 col-sm-12 bg-gray">
                <div class="checkout-cart-summary">
                    @if (isset($carts) && count($carts) > 0)
                    @php
                    $total = 0;
                    @endphp

                    @foreach ($carts as $key => $cartItem)
                    @php
                    $product = get_single_product($cartItem['product_id']);
                    $product_stock = $product->stocks->where('variant', $cartItem->variation)->first();

                    $total =
                    $total + cart_product_price($cartItem, $product, false) * $cartItem->quantity;
                    @endphp

                    @if (null != $product)
                    <div class="row d-flex align-items-center child-nth">
                        <div class="col-md-3 ">
                            <img src="{{ static_asset('assets/img/placeholder.jpg') }}"
                                data-src="{{ uploaded_asset($product->thumbnail_img) }}"
                                class="product-img img-fit lazyload size-60px has-transition"
                                alt="{{ $product->getTranslation('name') }}"
                                onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';">
                        </div>
                        <div class="col-md-7">
                            <span class="product-name">{{ $product->getTranslation('name') }}</span>
                            <span class="product-price">{{ $cartItem->quantity }} x
                                {!! cart_product_price($cartItem, $product) !!}</span>
                        </div>
                        <div class="col-md-2">
                            <span class="product-total">{!! single_price(cart_product_price($cartItem, $product, false)
                                * $cartItem->quantity) !!}</span>
                        </div>
                    </div>
                    @endif
                    @endforeach
                    @endif

                    <div class="cart-total">
                        <div class="d-flex justify-content-between align-items-center">
                            <span class="totaltxt">{{ translate('Total') }}</span>
                            <span class="carttotalprix">{!! single_price($total) !!}</span>
                        </div>

                        @if ($coupon_discount > 0 && $coupon_code)
                        <div class="d-flex justify-content-between align-items-center">
                            <span class="totaltxt">{{ translate('Sub Total') }}</span>
                            <span class="carttotalprix">{!! single_price($total - $coupon_discount) !!}</span>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
    $(document).ready(function () {
        $('.checkout-form-toggle').on('click', function () {
            const target = $(this).data('target');

            if ('#account-form' == target) {
                window.location.href = '{{ route('user.login') }}'
            }
        });

        $('#checkout-pay-btn').on('click', function () {
            if ($('#privacy-policy-check:checked').length > 0) {
                $('#checkout-form').submit();
            } else {
                CREA.plugins.notify('danger',
                    "{{ translate('You have to accept the privacy policy.') }}");
            }
        });
    });
</script>
@endsection