@extends('frontend.layouts.app')
@section('content')
    @php $lang = get_system_language()->code;  @endphp
    {{-- Featured Categories --}}

    {{-- Featured Products Start --}}
    @php
        $bg_color = get_setting('featured_products_bg_color');
        $bg_image = get_setting('featured_products_bg_image');
    @endphp
    <div id="section_featured"
        style="background-color: {{ $bg_color }}; @if ('' != $bg_image) background-image: url('{{ uploaded_asset($bg_image) }}'); @endif">
    </div>
    {{-- Featured Products End --}}


    {{-- New Products --}}
    <div id="section_newest">
    </div>
    {{-- Best Selling --}}
    <div id="section_best_selling">
    </div>
    
    {{-- Banner Section 3 --}}
    <div class="container">
        <div class="row bannerscol">
            <div class="col-md-4">
                <img src="https://deelgo.prowebplanners.com/public/assets/img/bnner.jpg">
            </div>
            <div class="col-md-4">
                <img src="https://deelgo.prowebplanners.com/public/assets/img/bnner.jpg">
            </div>
            <div class="col-md-4">
                <img src="https://deelgo.prowebplanners.com/public/assets/img/bnner.jpg">
            </div>
        </div>
    </div>

    @php $homeBanner3Images = get_setting('home_banner3_images', null, $lang);   @endphp
    {{-- Category wise Products --}}
    <div id="section_home_categories" class="">
    </div>
    {{-- Featured Categories --}}
    @if (count($all_categories) > 0)
        <section class="categories-sec-bot">
            <div class="container">
                <!-- Categories -->
                <div class="bg-red ">
                    <div class="featured-cats-bot  ">
                        @foreach ($all_categories->take(99) as $key => $category)
                            @php
                                $category_name = $category->getTranslation('name');
                            @endphp
                            <div class="cat-item-bot">
                                <div class=" text-center ">
                                    <div class="px-0">
                                        <span class="text-dark mb-0 text-truncate-2">
                                            <a href="{{ route('products.category', $category->slug) }}"
                                                title="{{ $category_name }}" class="text-center ">
                                                {{ $category_name }}
                                            </a>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </section>
    @endif
@endsection
