@php
    $best_selling_products = get_best_selling_products(20);
@endphp
@if (get_setting('best_selling') == 1 && count($best_selling_products) > 0)
    <section class="margin-globe">
        <div class="container defcar">
            <!-- Top Section -->
            <div class="d-flex btnrow align-items-baseline justify-content-between">
                <!-- Title -->
                <h3 class="maintitle fw-400">
                    <span class="">{{ translate('Best Selling') }}</span>
                </h3>
                <!-- Links -->
                <a class="viewall" href="{{ route('search', ['sort_by' => 'newest']) }}">{{ translate('View All') }}</a>
            </div>
            <!-- Product Section -->
            <div class="def   ">
                <div class="crea-carousel carstyle2 sm-gutters-8  " data-items="3" data-xl-items="3" data-lg-items="2"
                    data-md-items="2" data-sm-items="1" data-xs-items="1" data-arrows='true' data-dots='true'
                    data-infinite="true">
                    @foreach ($best_selling_products as $key => $product)
                        <div class="carousel-box px-2 position-relative  ">
                            @include(
                                // 'frontend.' . get_setting('homepage_select') . '.partials.product_box_2',
                                'frontend.' . get_setting('homepage_select') . '.partials.product_box_5',
                                ['product' => $product]
                            )
                        </div>
                    @endforeach
                </div>

                <button type="button" class="slick-next2 slick-arrow" style=""><i
                        class="las la-arrow-right"></i></button>
                <button type="button" class="slick-prev2 slick-arrow" style=""><i
                        class="las la-arrow-left"></i></button>
            </div>
        </div>
    </section> 
@endif


<script type="text/javascript">
    jQuery('.carstyle2').slick({
        slidesToShow: 6,
        slidesToScroll: 2,
        dots: false,
        arrows: true,
        speed: 1000,
        autoplay: true,
        autoplaySpeed: 3000,
        prevArrow: jQuery('.slick-prev2'),
        nextArrow: jQuery('.slick-next2'),

        responsive: [

           
           {
                breakpoint: 850,
                settings: {
        slidesToScroll: 1,
                    slidesToShow: 2
                }
            },
            {
                breakpoint: 480,
                settings: {
        slidesToScroll: 1,
                    slidesToShow: 1
                }
            }
        ]
    });
</script>
