@if (get_setting('home_categories') != null)
    @php
        $home_categories = json_decode(get_setting('home_categories'));
        $categories = get_category($home_categories);
    @endphp
    @foreach ($categories as $category_key => $category)
        @php
            $category_params = $home_categories[$category_key];
            // var_dump($category_params->number_of_grid);
            $category_name = $category->getTranslation('name');
            $category_slug = $category->slug;
            // var_dump($category->slug);
        @endphp
        <div class="container">
            <div class="d-flex btnrow align-items-baseline justify-content-between">
                <h3 class="maintitle fw-400">
                    {{ $category_name }} 
                </h3>

                <a class="viewall"
                    href="{{ route('products.category', ['category_slug' => $category_slug]) }}">{{ translate('View All') }}</a>
            </div>
        </div>
        <section class="@if ($category_key != 0)  @endif"
           >
            <div class="container">
                <div class="row gutters-8">
                    <!-- Home category banner & name -->
                    {{-- <div class="col-xl-3 col-lg-4 col-md-5">
                        <div class="h-200px h-sm-250px h-md-340px">
                            <a href="{{ route('products.category', $category->slug) }}" class="d-block h-100 w-100 w-xl-auto hov-scale-img overflow-hidden home-category-banner"> 
                                <span class="position-absolute h-100 w-100 overflow-hidden">
                                    <img src="{{ isset($category->coverImage->file_name) ? my_asset($category->coverImage->file_name) : static_asset('assets/img/placeholder.jpg') }}"
                                        alt="{{ $category_name }}"
                                        class="img-fit h-100 has-transition"
                                        onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';">
                                </span>
                                <span class="home-category-name fs-15 fw-600 text-white text-center">
                                    <span class="">{{ $category_name }}</span>
                                </span>
                            </a>
                        </div>
                    </div> --}}
                    <!-- Category Products -->
                    <div class="col-xl-12 col-lg-12 col-md-12 defcar">
                        <div class="crea-carousel carstyle-hc-{{ $category_key }} arrow-x-0 border-right arrow-inactive-none"
                            data-items="{{ $category_params->number_of_grid }}"
                            data-xxl-items="{{ $category_params->number_of_grid }}" data-xl-items="4.5"
                            data-lg-items="3" data-md-items="2" data-sm-items="1" data-xs-items="1" data-arrows='true'
                            data-infinite='false'>
                            @foreach (get_cached_products($category->id) as $product_key => $product)
                                <div class="carousel-box px-2 position-relative has-transition">
                                    @include(
                                        'frontend.' .
                                            get_setting('homepage_select') .
                                            '.partials.product_box_5',
                                            // '.partials.product_box_' .
                                            // $category_params->style_type,
                                        ['product' => $product]
                                    )
                                </div>
                            @endforeach
                        </div>
                        <button type="button" class="slick-next slick-next-hc-{{ $category_key }} slick-arrow"
                            style=""><i class="las la-arrow-right"></i></button>
                        <button type="button" class="slick-prev slick-prev-hc-{{ $category_key }} slick-arrow"
                            style=""><i class="las la-arrow-left"></i></button>
                    </div>
                </div>
            </div>
        </section>

        <script type="text/javascript">
            jQuery('.carstyle-hc-{{ $category_key }}').slick({
                slidesToShow: 6,
                slidesToScroll: 2,
                dots: false,
                arrows: true,
                speed: 1000,
                autoplay: true,
                autoplaySpeed: 3500,
                prevArrow: jQuery('.slick-prev-hc-{{ $category_key }}'),
                nextArrow: jQuery('.slick-next-hc-{{ $category_key }}'),
                responsive: [{
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: 5
                        }
                    },
                    {
                        breakpoint: 850,
                        settings: {
                            slidesToScroll: 1,
                            slidesToShow: 2
                        }
                    },
                    {
                        breakpoint: 480,
                        settings: {
                            slidesToScroll: 1,
                            slidesToShow: 1
                        }
                    }
                ]
            });
        </script>
    @endforeach
@endif
