@php
    $cart_added = [];
@endphp
<div class="crea-card-box h-auto bg-white">
    <div class="position-relative img-fit overflow-hidden">
        @php
            $product_url = route('product', $product->slug);

        @endphp
        <!-- Image -->
        <a href="{{ $product_url }}" class="d-block h-100">
            <img class="lazyload mx-auto img-fit has-transition" src="{{ get_image($product->thumbnail) }}"
                alt="{{ $product->getTranslation('name') }}" title="{{ $product->getTranslation('name') }}"
                onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';">
        </a>

        {{-- <span class="product-cat-name">{{ get_category_name($product->category_id) }}</span> --}}
      
    </div>
    <div class="p-2 p-md-3 text-left txtbx">
        <!-- Product name -->
        <h3 class="fw-400 fs-13 text-truncate-2 lh-1-4 mb-0  text-left">
            <a href="{{ $product_url }}" class="d-block text-reset hov-text-primary"
                title="{{ $product->getTranslation('name') }}">{{ $product->getTranslation('name') }}</a>
        </h3>

        {{-- Location --}}
        <div class="row mt-2">
            <div class="col-md-12 markerholder">
                <span><i class="las la-2x la-map-marker"></i></span>
                <span class="cityblock">{{ $product->event_city }}</span>
            </div>
        </div>

        {{-- CountDown --}}
        <div class=" d-flex align-items-center mb-3">
            <span><i class="las la-2x la-stopwatch"></i></span>
            <span>
                <div class="crea-count-down-box align-items-center"
                    data-date="{{ date('Y/m/d H:i:s', $product->event_start_date) }}">
                </div>
            </span>
        </div>

        <div class="row d-flex align-items-center">
            <div class="colmob2-prod col-md-6 text-left">
                <div class="fs-14 mt-0">
                    @if ($product->auction_product == 0)
                        <div class="beforeprice"><?php echo e(translate('From')); ?> :</div>
                         <span class="fw-700 text-primary">{!! home_discounted_base_price($product) !!}</span>
                    @endif
                </div>
            </div>
            <div class="colmob2-prod col-md-6 text-right">
                <a class="btn btn-warning @if (in_array($product->id, $cart_added)) active @endif" href="{{ $product_url }}">
                    <span class="cart-btn-text">
                        {{ translate('Add to Cart') }}
                    </span>
                </a>
            </div>
        </div>
    </div>
</div>
