@php
    $cart_added = [];
@endphp
<div class="crea-card-box h-auto bg-white">
    <div class="position-relative  h-md-200px img-fit overflow-hidden">
        @php
            $product_url = route('product', $product->slug);
            if ($product->auction_product == 1) {
                $product_url = route('auction-product', $product->slug);
            }
        @endphp
        <!-- Image -->
        <a href="{{ $product_url }}" class="d-block h-100">
            <img class="lazyload mx-auto img-fit has-transition" src="{{ get_image($product->thumbnail) }}"
                alt="{{ $product->getTranslation('name') }}" title="{{ $product->getTranslation('name') }}"
                onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';">
        </a>

        <!-- Wholesale tag -->
        @if ($product->wholesale_product)
            <span class="absolute-top-left fs-11 text-white fw-700 px-2 lh-1-8 ml-1 mt-1"
                style="background-color: #455a64; @if (discount_in_percentage($product) > 0) top:25px; @endif">
                {{ translate('Wholesale') }}
            </span>
        @endif
    </div>
    <div class="p-2 pl-3 text-left txtbx">
        <div class="row d-flex align-items-center "> 
            <div class="col-md-3">
                <div class="fs-14 mt-0">
                    @if ($product->auction_product == 0)
                        <!-- price -->
                        <div class="beforeprice">{{ translate('From') }} :</div>
                        <span class="fw-700 text-primary">{!! home_discounted_base_price($product) !!}</span>
                    @endif
                    @if ($product->auction_product == 1)
                        <!-- Bid Amount -->
                        <div class="">
                            <span class="fw-700 text-primary">{{ single_price($product->starting_bid) }}</span>
                        </div>
                    @endif
                </div>
            </div>

            <div class=" col-md-5 d-flex align-items-cnter colmob3-prod">
                {{-- CountDown --}}
                <div class="d-flex align-items-center">
                    <span><i class="las la-2x la-stopwatch"></i></span>
                    <span>
                        <div class="crea-count-down-box align-items-center" 
                            {{-- data-date="2024/12/10 12:54:00" --}}
                            data-date="{{ date('Y/m/d H:i:s', $product->event_start_date) }}"> 
                        </div>
                    </span>
                </div>
            </div>

            <div class="col-md-4 colmob3-prod">
                <a class="btn btn-warning @if (in_array($product->id, $cart_added)) active @endif" href="{{ $product_url }}">
                    <span class="cart-btn-text">
                        {{ translate('Add to Cart') }}
                    </span>
                </a>
            </div>
        </div>
    </div>
</div>
