@php
    $cart_added = [];
@endphp
<div class="crea-card-box h-auto bg-white">
    <div class="position-relative  h-md-200px img-fit overflow-hidden">
        @php
            $product_url = route('product', $product->slug);
            if ($product->auction_product == 1) {
                $product_url = route('auction-product', $product->slug);
            }
        @endphp
        <!-- Image -->
        <a href="{{ $product_url }}" class="d-block h-100">
            <img class="lazyload mx-auto img-fit has-transition" src="{{ get_image($product->thumbnail) }}"
                alt="{{ $product->getTranslation('name') }}" title="{{ $product->getTranslation('name') }}"
                onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';">
        </a>
    </div>
    <div class="p-2 p-md-3 text-left txtbx">
         <!-- Product name --> 
        <h3 class="fw-400 fs-13 text-truncate-2 lh-1-4 mb-0  text-left">
            <a href="{{ $product_url }}" class="d-block text-reset hov-text-primary"
                title="{{ $product->getTranslation('name') }}">{{ $product->getTranslation('name') }}</a>
        </h3> 

        <div class="row d-flex align-items-center">
            <div class="col-md-6 colmob2-prod text-left">
                <div class="fs-14 mt-0">
                    @if ($product->auction_product == 0)
                        <!-- price -->
                        <div class="beforeprice">{{ translate('From') }} :</div>
                        <span class="fw-700 text-primary">{!! home_discounted_base_price($product) !!}</span>
                    @endif
                    @if ($product->auction_product == 1)
                        <!-- Bid Amount -->
                        <div class="">
                            <span class="fw-700 text-primary">{{ single_price($product->starting_bid) }}</span>
                        </div>
                    @endif
                </div>
            </div>

            <div class="col-md-6 colmob2-prod text-right">
                <a class="btn btn-warning @if (in_array($product->id, $cart_added)) active @endif" href="{{ $product_url }}">
                    <span class="cart-btn-text">
                        {{ translate('Add to Cart') }}
                    </span>
                </a>
            </div>
        </div>
    </div>
</div>
