@php
    $cart_added = [];
@endphp
<div class="crea-card-box h-auto bg-white">
    <div class="position-relative img-fit overflow-hidden">
        @php
            $product_url = route('product', $product->slug);
            if ($product->auction_product == 1) {
                $product_url = route('auction-product', $product->slug);
            }
        @endphp
        <!-- Image -->
        <a href="{{ $product_url }}" class="d-block h-100">
            <img class="lazyload mx-auto img-fit has-transition"
                src="{{ $product->featuredImage ? get_image($product->featuredImage) : get_image($product->thumbnail) }}"
                alt="{{ $product->getTranslation('name') }}" title="{{ $product->getTranslation('name') }}"
                onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';">
        </a>

        <div class="col-md-12 text-center">
            <a class="btn btn-warning hover-add-to-cart @if (in_array($product->id, $cart_added)) active @endif"
                href="{{ $product_url }}">
                <span class="cart-btn-text">
                    {{ translate('Buy Now') }}
                </span>
            </a>
        </div>
    </div>
</div>
