@php
    $cart_added = [];

    $type = $product->type;
    $timestamp = $product->event_start_date;
    $_date = new DateTime("@$timestamp");
    $currentDate = new DateTime();
@endphp
<div class="crea-card-box h-auto bg-white">
    <div class="position-relative img-fit overflow-hidden">
        @php
            $product_url = route('product', $product->slug);
        @endphp
        <!-- Image -->
        <a href="{{ $product_url }}" class="d-block h-100">
            <img class="lazyload mx-auto img-fit has-transition" src="{{ get_image($product->thumbnail) }}"
                alt="{{ $product->getTranslation('name') }}" title="{{ $product->getTranslation('name') }}"
                onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';">
        </a>

     
    </div>
    <div class="p-2 p-md-3 text-left txtbx">
        {{-- Category name --}}
     

        {{-- Product name --}}
        <h3 class="fw-400 fs-13 text-truncate-2 lh-1-4 mb-0  text-left mt-3 mb-2">
            <a href="{{ $product_url }}" class="d-block text-reset hov-text-primary"
                title="{{ $product->getTranslation('name') }}">{{ $product->getTranslation('name') }}</a>
        </h3>

        <div class="contprd-col">
            @if ($product->city)
                {{-- Location --}}
                <div class="row mt-1">
                    <div class="col-md-12 markerholder">
                        <span><img class="localprd" src="{{ static_asset('assets/img/location.webp') }}"></span>
                        <span class="cityblock">{{ optional($product->city)->getTranslation('name') }}</span>
                    </div>
                </div>
            @endif

            @if ('' !== $product->event_start_date)
                {{-- CountDown --}}
                @if ($_date > $currentDate)
                    <div class="d-flex align-items-center mb-1">
                        <span><img class="timeprd" src="{{ static_asset('assets/img/time.webp') }}"></span>
                        <span>
                            <div class="crea-count-down-box align-items-center"
                                data-date="{{ date('Y/m/d H:i:s', $product->event_start_date) }}">
                            </div>
                        </span>
                    </div>
                @endif
            @endif


            {{-- Reviews & Sales number --}}
            <div class="row ">
                @php
                    $rating = $product->rating > 0 ? $product->rating : $product->default_reviews_stars;
                @endphp
                <div class="col-12 text-right">
                    @if (0 < $rating)
                        <span class="rating">
                            {{ renderStarRating($rating) }}
                        </span>
                    @endif
                </div>
                <div class="col-12 text-right mb-1">
                    @if (0 < $product->default_sales)
                        @if (1 == $product->default_sales)
                            {{ $product->default_sales }} {{ translate('buyer') }}
                        @else
                            @if (10 > $product->default_sales)
                                {{ $product->default_sales }} {{ translate('buyers') }}
                            @else
                                +{{ $product->default_sales }} {{ translate('buyers') }}
                            @endif
                        @endif
                    @endif
                </div>
            </div>

        </div>

        <div class="price-flash-message">
            {{-- Price --}}
            <div class="row d-flex justify-content-center align-items-center">
                <div class="colmob2-prod text-center">
                    <div class="fs-14 mt-0">
                        <span class="fw-700 text-primary">
                            {!! home_discounted_base_price($product) !!}
                        </span>
                    </div>
                </div>
            </div>

             
        </div>

        {{-- Action Button --}}
        <div class="text-center">
             
                <a class="btn btn-warning 
                @if (in_array($product->id, $cart_added)) active @endif
                @if ($_date < $currentDate || 0 == $product->stocks->first()->qty) disabled @endif"
                    href="{{ $product_url }}">
                    <span class="cart-btn-text">
                        @if (0 == $product->stocks->first()->qty)
                            {{ translate('Sold out') }}
                        @else
                            @if ($_date < $currentDate)
                                @if ('event' == $product->nature)
                                    {{ translate('Event is over') }}
                                @else
                                    @if ('deal' == $product->nature)
                                        {{ translate('End of deal') }}
                                    @else
                                        {{ translate('Add to cart') }}
                                    @endif
                                @endif
                            @else
                                @if ('event' == $product->nature)
                                    {{ translate('Buy') }}
                                @else
                                    {{ translate('Add to cart') }}
                                @endif
                            @endif
                        @endif
                    </span>
                </a>
        
        </div>
    </div>
</div>
