@extends('frontend.layouts.app')

@section('content')
    {{-- Featured Categories --}}
    @if (count($featured_categories) > 0)
        <section class="categories-sec">
            <div class="container">
                <!-- Categories -->
                <div>
                    <div class="d-flex">
                        <div class=" px-0 cat-item first-item-cat">
                            <div class=" text-center ">
                                <div class="px-0">
                                    <span class="text-dark mb-0  text-truncate-2">
                                        <a href="{{ route('home') }}/category/new-in" title="New in">
                                            {{ translate('NEW IN') }}
                                        </a>
                                    </span>
                                </div>
                            </div>
                        </div>
                        @foreach ($featured_categories->take(7) as $key => $category)
                            @php
                                $category_name = $category->getTranslation('name');
                            @endphp
                            <div class=" px-0 cat-item ">
                                <div class=" itemhold text-center ">
                                    <div>
                                        <a href="{{ route('products.category', $category->slug) }}"
                                            title="{{ $category_name }}"> <img
                                                src="{{ isset($category->bannerImage->file_name) ? my_asset($category->bannerImage->file_name) : static_asset('assets/img/placeholder.jpg') }}"
                                                class="lazyload h-auto mx-auto has-transition"
                                                alt="{{ $category->getTranslation('name') }}"
                                                onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';"></a>
                                    </div>
                                    <div class="px-0">
                                        <span class="text-dark mb-0 text-truncate-2">
                                            <a href="{{ route('products.category', $category->slug) }}"
                                                title="{{ $category_name }}">
                                                {{ $category_name }}

                                                @if (count($category->childrenCategories) > 0)
                                                    <span class="children-toggle"></span>
                                                @endif
                                            </a>
                                        </span>
                                    </div>
                                    <ul class="holdermenu-above">
                                        @foreach ($category->childrenCategories->take(6) as $key => $child_category)
                                            <li class="itemmenu-above"> <a
                                                    href="{{ route('products.category', $child_category->slug) }}"
                                                    class="text-center text-light">
                                                    {{ $child_category->getTranslation('name') }}
                                                </a>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </section>
    @endif

    <div class="container contact-form-container">
        <div class="row">
            <div class="col-md-6">
                <div class="card card-left">
                    <div class="container">
                        <p class="contacttitle-page">{{ translate('Contact us')}}</p>
                        <p class="txtcontact">{{ translate("If you need assistance, you can contact our customer service by calling our infoline, sending us an email or filling out the contact form, we will respond to you as soon as possible.")}}
                        </p>

                        <p>
                        <span class="contact-iconholder"><i class="fa-solid fa-phone"></i></span>
                            <span>{{ translate('Infoline') }} : <strong>+212630 06 30 06</strong>
                        {{ translate(' (Mon to Fri ') }} <strong>9h - 12</strong> {{ translate('& Sat') }} <strong>13h - 17h</strong>) 
                        </span> 
                        </p>

                        <p>
                    <span class="contact-iconholder">   <i class="fa-regular fa-envelope"></i></span>
                        <span>{{ translate('Email') }} :
                        <a style="color:#000" href="mailto:contact@deelgo.com">contact@deelgo.com</a>
                    </span> 
                        </p>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="card card-right">
                    <form action="{{ route('contact.process') }}" method="POST">
                        @csrf

                        <div class="container">
                            <div class="form-group">
                                <label for="first_name">{{ translate('First Name') }}*</label>
                                <input class="form-control" placeholder="{{ translate('First Name') }}" id="first_name" name="first_name" type="text">
                            </div>

                            <div class="form-group">
                                <label for="last_name">{{ translate('Last Name') }}*</label>
                                <input class="form-control" placeholder="{{ translate('Last Name') }}" id="last_name" name="last_name" type="text">
                            </div>

                            <div class="form-group">
                                <label for="email">{{ translate('Email') }}*</label>
                                <input class="form-control" placeholder="{{ translate('Email') }}" id="email" name="email" type="email">
                            </div>

                            <div class="form-group">
                                <label for="phone">{{ translate('Phone') }}*</label>
                                <input class="form-control" placeholder="{{ translate('Phone') }}" id="phone" name="phone" type="tel">
                            </div>

                            <div class="form-group">
                                <label for="subject">{{ translate('Subject') }}*</label>
                                <select class="form-control" placeholder="{{ translate('Subject') }}" id="subject" name="subject">
                                    <option value="">{{ translate('Select option') }}</option>
                                    <option value="1">1-{{ translate('I don\'t receive today\'s emails') }}</option>
                                    <option value="2">2-{{ translate('Problems during purchase') }}</option>
                                    <option value="3">3-{{ translate('I forgot my password') }}</option>
                                    <option value="4">4-{{ translate('Complaints') }}</option>
                                    <option value="5">5-{{ translate('Suggestions') }}</option>
                                    <option value="6">6-{{ translate('Invoices') }}</option>
                                    <option value="7">7-{{ translate('Others') }}</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="message">{{ translate('Message') }}</label>
                                <textarea class="form-control" id="message" name="message"></textarea>
                            </div>

                            <button class="btn" type="submit">{{ translate('Send my message') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection