<div class="page-form">
    <div class="page-form-inner">
        <form action="{{ route('contact.careers_form') }}" method="POST" enctype="multipart/form-data">
            @csrf

            <div class="container">
                <div class="form-group">
                    <label for="first_name">{{ translate('First Name') }} *</label>
                    <input class="form-control" placeholder="{{ translate('First Name') }}" id="first_name"
                        name="first_name" type="text" value="{{ old('first_name') }}">
                    @error('first_name')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="last_name">{{ translate('Last Name') }} *</label>
                    <input class="form-control" placeholder="{{ translate('Last Name') }}" id="last_name"
                        name="last_name" type="text" value="{{ old('last_name') }}">
                    @error('last_name')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="email">{{ translate('Email') }} *</label>
                    <input class="form-control" placeholder="{{ translate('Email') }}" id="email" name="email"
                        type="email" value="{{ old('email') }}">
                    @error('email')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="phone">{{ translate('Phone') }} *</label>
                    <input class="form-control" placeholder="{{ translate('Phone') }}" id="phone" name="phone"
                        type="tel" value="{{ old('phone') }}">
                    @error('phone')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="file">{{ translate('Attach document') }} *</label>
                    <input class="form-control" type="file" name="file" id="file">
                    @error('file')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="message">{{ translate('Message') }} *</label>
                    <textarea class="form-control" id="message" name="message">{{ old('message') }}</textarea>
                    @error('message')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                <!-- Recaptcha -->
                @if (get_setting('google_recaptcha') == 1)
                    <div class="form-group">
                        <div class="g-recaptcha" data-sitekey="{{ env('CAPTCHA_KEY') }}"></div>
                    </div>
                    @if ($errors->has('g-recaptcha-response'))
                        <span class="invalid-feedback" role="alert" style="display: block;">
                            <strong>{{ $errors->first('g-recaptcha-response') }}</strong>
                        </span>
                    @endif
                @endif

                <div class="form-group">
                    <button class="btn" type="submit">{{ translate('Send my condidature') }}</button>
                </div>
                <small class="text-white">* {{ translate('Required fields') }}</small>
            </div>
        </form>
    </div>
</div>
