<div class="page-form">
    <div class="page-form-inner">
        <form action="{{ route('contact.process_contact_form') }}" method="POST">
            @csrf

            <div class="container">
                <div class="form-group">
                    <label for="first_name">{{ translate('First Name') }} *</label>
                    <input class="form-control" placeholder="{{ translate('First Name') }}" id="first_name"
                        name="first_name" type="text">
                    @error('first_name')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="last_name">{{ translate('Last Name') }} *</label>
                    <input class="form-control" placeholder="{{ translate('Last Name') }}" id="last_name"
                        name="last_name" type="text">
                    @error('last_name')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="email">{{ translate('Email') }} *</label>
                    <input class="form-control" placeholder="{{ translate('Email') }}" id="email" name="email"
                        type="email">
                    @error('email')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="phone">{{ translate('Phone') }} *</label>
                    <input class="form-control" placeholder="{{ translate('Phone') }}" id="phone" name="phone"
                        type="tel">
                    @error('phone')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="subject">{{ translate('Subject') }} *</label>
                    <select class="form-control" placeholder="{{ translate('Subject') }}" id="subject"
                        name="subject">
                        <option value="">{{ translate('Select option') }}</option>
                        <option value="1">{{ translate('I don\'t receive today\'s emails') }}</option>
                        <option value="2">{{ translate('Problems during purchase') }}</option>
                        <option value="3">{{ translate('I forgot my password') }}</option>
                        <option value="4">{{ translate('Complaints') }}</option>
                        <option value="5">{{ translate('Suggestions') }}</option>
                        <option value="6">{{ translate('Invoices') }}</option>
                        <option value="7">{{ translate('Others') }}</option>
                    </select>
                    @error('subject')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="message">{{ translate('Message') }} *</label>
                    <textarea class="form-control" id="message" name="message"></textarea>
                    @error('message')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                <!-- Recaptcha -->
                @if (get_setting('google_recaptcha') == 1)
                    <div class="form-group">
                        <div class="g-recaptcha" data-sitekey="{{ env('CAPTCHA_KEY') }}"></div>
                    </div>
                    @if ($errors->has('g-recaptcha-response'))
                        <span class="invalid-feedback" role="alert" style="display: block;">
                            <strong>{{ $errors->first('g-recaptcha-response') }}</strong>
                        </span>
                    @endif
                @endif

                <div class="form-group">
                    <button class="btn" type="submit">{{ translate('Send my message') }}</button>
                </div>
                <small class="text-white">* {{ translate('Required fields') }}</small>
            </div>
        </form>
    </div>
</div>
