<div class="page-form">
    <div class="page-form-inner">
        <form id="reg-form" class="form-default" role="form" action="{{ route('shops.store') }}" method="POST">
            @csrf

            <div class="row">
                <div class="col-md-12">
                    <h2>{{ translate('Boost your sales with deelgo') }}</h2>
                    <p>{{ translate('Start today with no upfront costs!') }}</p>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    {{-- Last name --}}
                    <div class="form-group">
                        <label for="last_name">{{ translate('Last Name') }}</label>
                        <input type="text" id="last_name"
                            class="form-control rounded-0{{ $errors->has('last_name') ? ' is-invalid' : '' }}"
                            value="{{ old('last_name') }}" placeholder="{{ translate('Last Name') }}" name="last_name"
                            required>
                        @if ($errors->has('last_name'))
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('last_name') }}</strong>
                            </span>
                        @endif
                    </div>
                </div>

                <div class="col-md-6">
                    {{-- First name --}}
                    <div class="form-group">
                        <label for="first_name">{{ translate('First Name') }}</label>
                        <input type="text" id="first_name"
                            class="form-control rounded-0{{ $errors->has('first_name') ? ' is-invalid' : '' }}"
                            value="{{ old('first_name') }}" placeholder="{{ translate('First Name') }}"
                            name="first_name" required>
                        @if ($errors->has('first_name'))
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('first_name') }}</strong>
                            </span>
                        @endif
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    {{-- Company name --}}
                    <div class="form-group">
                        <label for="company_name">{{ translate('Company Name') }}</label>
                        <input type="text" id="company_name"
                            class="form-control rounded-0{{ $errors->has('company_name') ? ' is-invalid' : '' }}"
                            value="{{ old('company_name') }}" placeholder="{{ translate('Company Name') }}"
                            name="company_name" required>
                        @if ($errors->has('company_name'))
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('company_name') }}</strong>
                            </span>
                        @endif
                    </div>
                </div>

                <div class="col-md-6">
                    {{-- Category --}}
                    <div class="form-group">
                        <label for="category">{{ translate('Category') }}</label>
                        <select name="category" id="category"
                            class="form-control rounded-0{{ $errors->has('category') ? ' is-invalid' : '' }}" required>
                            <option value="">{{ translate('Choose category') }}</option>
                            @foreach (get_parent_categories() as $category)
                                <option value="{{ $category->id }}">{{ $category->name }}
                                </option>
                            @endforeach
                        </select>
                        @if ($errors->has('category'))
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('category') }}</strong>
                            </span>
                        @endif
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    {{-- Phone --}}
                    <div class="form-group">
                        <label for="phone">{{ translate('Phone') }}</label>
                        <input type="tel" id="phone"
                            class="form-control rounded-0{{ $errors->has('phone') ? ' is-invalid' : '' }}"
                            value="{{ old('phone') }}" placeholder="{{ translate('Phone') }}" name="phone"
                            required>
                        @if ($errors->has('phone'))
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('phone') }}</strong>
                            </span>
                        @endif
                    </div>
                </div>

                <div class="col-md-6">
                    {{-- Email --}}
                    <div class="form-group">
                        <label for="email">{{ translate('Email') }}</label>
                        <input type="email" id="email"
                            class="form-control rounded-0{{ $errors->has('email') ? ' is-invalid' : '' }}"
                            value="{{ old('email') }}" placeholder="{{ translate('Email') }}" name="email"
                            required>
                        @if ($errors->has('email'))
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('email') }}</strong>
                            </span>
                        @endif
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    {{-- Address --}}
                    <div class="form-group">
                        <label for="address">{{ translate('Address') }}</label>
                        <input type="text" id="address"
                            class="form-control rounded-0{{ $errors->has('address') ? ' is-invalid' : '' }}"
                            value="{{ old('address') }}" placeholder="{{ translate('Address') }}" name="address"
                            required>
                        @if ($errors->has('address'))
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('address') }}</strong>
                            </span>
                        @endif
                    </div>
                </div>
                <div class="col-md-6">
                    {{-- City --}}
                    <div class="form-group">
                        <label for="city">{{ translate('City') }}</label>
                        <input type="text"
                            class="form-control rounded-0{{ $errors->has('city') ? ' is-invalid' : '' }}"
                            value="{{ old('city') }}" placeholder="{{ translate('City') }}" name="city" required>
                        @if ($errors->has('city'))
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('city') }}</strong>
                            </span>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Recaptcha -->
            @if (get_setting('google_recaptcha') == 1)
                <div class="form-group">
                    <div class="g-recaptcha" data-sitekey="{{ env('CAPTCHA_KEY') }}">
                    </div>
                </div>
                @if ($errors->has('g-recaptcha-response'))
                    <span class="invalid-feedback" role="alert" style="display: block;">
                        <strong>{{ $errors->first('g-recaptcha-response') }}</strong>
                    </span>
                @endif
            @endif

            <!-- Submit Button -->
            <div class="mb-4 mt-4">
                <button type="submit"
                    class="btn btn-primary btn-block fw-600 rounded-0">{{ translate('Register Your Shop') }}</button>
            </div>
        </form>
    </div>
</div>
