<div class="page-form">
    <div class="page-form-inner">
        <form action="{{ route('contact.process_propose_event_form') }}" method="POST">
            @csrf

            <div class="container">
                <div class="form-group">
                    <label for="event">{{ translate('Event') }} *</label>
                    <input class="form-control" placeholder="{{ translate('Event') }}" id="event" name="event"
                        type="text" value="{{ old('event') }}">

                    @error('event')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="organizer">{{ translate('Organizer') }} *</label>
                    <input class="form-control" placeholder="{{ translate('Organizer') }}" id="organizer"
                        name="organizer" type="text" value="{{ old('organizer') }}">

                    @error('organizer')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="email">{{ translate('Email') }} *</label>
                    <input class="form-control" placeholder="{{ translate('Email') }}" id="email" name="email"
                        type="email" value="{{ old('email') }}">

                    @error('email')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="phone">{{ translate('Phone') }} *</label>
                    <input class="form-control" placeholder="{{ translate('Phone') }}" id="phone" name="phone"
                        type="tel" value="{{ old('phone') }}">

                    @error('phone')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="city">{{ translate('City') }} *</label>
                    <input class="form-control" placeholder="{{ translate('City') }}" id="city" name="city"
                        type="text" value="{{ old('city') }}">

                    @error('city')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="message">{{ translate('Message') }} *</label>
                    <textarea class="form-control" placeholder="{{ translate('Message') }}" id="message" name="message">{{ old('message') }}</textarea>

                    @error('message')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                <!-- Recaptcha -->
                @if (get_setting('google_recaptcha') == 1)
                    <div class="form-group">
                        <div class="g-recaptcha" data-sitekey="{{ env('CAPTCHA_KEY') }}"></div>
                    </div>
                    @if ($errors->has('g-recaptcha-response'))
                        <span class="invalid-feedback" role="alert" style="display: block;">
                            <strong>{{ $errors->first('g-recaptcha-response') }}</strong>
                        </span>
                    @endif
                @endif

                <div class="form-group">
                    <button type="submit" class="btn">{{ translate('Send') }}</button>
                </div>
                <small class="text-white">* {{ translate('Required fields') }}</small>
            </div>
        </form>
    </div>
</div>
