<div class="crea-user-sidenav-wrap position-relative z-1 rounded-0">
    <div class="crea-user-sidenav overflow-auto c-scrollbar-light px-4 pb-4">
        <!-- Close button -->
        <div class="d-xl-none">
            <button class="btn btn-sm p-2 " data-toggle="class-toggle" data-backdrop="static"
                data-target=".crea-mobile-side-nav" data-same=".mobile-side-nav-thumb">
                <i class="las la-times la-2x"></i>
            </button>
        </div>
        @php
            $user = auth()->user();
            $user_avatar = null;
            $carts = [];
            if ($user && $user->avatar_original != null) {
                $user_avatar = uploaded_asset($user->avatar_original);
            }
        @endphp
        <!-- Customer info -->
        <div class="p-4 text-center mb-4 border-bottom position-relative">
            <!-- Image -->
            <span class="avatar avatar-md mb-3">
                @if ($user->avatar_original != null)
                    <img src="{{ $user_avatar }}"
                        onerror="this.onerror=null;this.src='{{ static_asset('assets/img/avatar-place.png') }}';">
                @else
                    <img src="{{ static_asset('assets/img/avatar-place.png') }}" class="image rounded-circle"
                        onerror="this.onerror=null;this.src='{{ static_asset('assets/img/avatar-place.png') }}';">
                @endif
            </span>
            <!-- Name -->
            <h4 class="h5 fs-14 mb-1 fw-700 text-dark">{{ $user->name }}</h4>
            <!-- Phone -->
            @if ($user->phone != null)
                <div class="text-truncate opacity-60 fs-12">{{ $user->phone }}</div>
                <!-- Email -->
            @else
                <div class="text-truncate opacity-60 fs-12">{{ $user->email }}</div>
            @endif
        </div>
        <!-- Menus -->
        <div class="sidemnenu">
            <ul class="crea-side-nav-list mb-3 pb-3 border-bottom" data-toggle="crea-side-menu">
                <!-- Dashboard -->
                <li class="crea-side-nav-item">
                    <a href="{{ route('dashboard') }}" class="crea-side-nav-link {{ areActiveRoutes(['dashboard']) }}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                            <g id="Group_24768" data-name="Group 24768" transform="translate(3495.144 -602)">
                                <path id="Path_2916" data-name="Path 2916"
                                    d="M15.3,5.4,9.561.481A2,2,0,0,0,8.26,0H7.74a2,2,0,0,0-1.3.481L.7,5.4A2,2,0,0,0,0,6.92V14a2,2,0,0,0,2,2H14a2,2,0,0,0,2-2V6.92A2,2,0,0,0,15.3,5.4M10,15H6V9A1,1,0,0,1,7,8H9a1,1,0,0,1,1,1Zm5-1a1,1,0,0,1-1,1H11V9A2,2,0,0,0,9,7H7A2,2,0,0,0,5,9v6H2a1,1,0,0,1-1-1V6.92a1,1,0,0,1,.349-.76l5.74-4.92A1,1,0,0,1,7.74,1h.52a1,1,0,0,1,.651.24l5.74,4.92A1,1,0,0,1,15,6.92Z"
                                    transform="translate(-3495.144 602)" fill="#b5b5bf" />
                            </g>
                        </svg>
                        <span class="crea-side-nav-text ml-3">{{ translate('Dashboard') }}</span>
                    </a>
                </li>
                @php
                    $delivery_viewed = get_count_by_delivery_viewed();
                    $payment_status_viewed = get_count_by_payment_status_viewed();
                @endphp
                <!-- Purchase History -->
                <li class="crea-side-nav-item">
                    <a href="{{ route('purchase_history.index') }}"
                        class="crea-side-nav-link {{ areActiveRoutes(['purchase_history.index', 'purchase_history.details']) }}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                            <g id="Group_8109" data-name="Group 8109" transform="translate(-27.466 -542.963)">
                                <path id="Path_2953" data-name="Path 2953"
                                    d="M14.5,5.963h-4a1.5,1.5,0,0,0,0,3h4a1.5,1.5,0,0,0,0-3m0,2h-4a.5.5,0,0,1,0-1h4a.5.5,0,0,1,0,1"
                                    transform="translate(22.966 537)" fill="#b5b5bf" />
                                <path id="Path_2954" data-name="Path 2954"
                                    d="M12.991,8.963a.5.5,0,0,1,0-1H13.5a2.5,2.5,0,0,1,2.5,2.5v10a2.5,2.5,0,0,1-2.5,2.5H2.5a2.5,2.5,0,0,1-2.5-2.5v-10a2.5,2.5,0,0,1,2.5-2.5h.509a.5.5,0,0,1,0,1H2.5a1.5,1.5,0,0,0-1.5,1.5v10a1.5,1.5,0,0,0,1.5,1.5h11a1.5,1.5,0,0,0,1.5-1.5v-10a1.5,1.5,0,0,0-1.5-1.5Z"
                                    transform="translate(27.466 536)" fill="#b5b5bf" />
                                <path id="Path_2955" data-name="Path 2955"
                                    d="M7.5,15.963h1a.5.5,0,0,1,.5.5v1a.5.5,0,0,1-.5.5h-1a.5.5,0,0,1-.5-.5v-1a.5.5,0,0,1,.5-.5"
                                    transform="translate(23.966 532)" fill="#b5b5bf" />
                                <path id="Path_2956" data-name="Path 2956"
                                    d="M7.5,21.963h1a.5.5,0,0,1,.5.5v1a.5.5,0,0,1-.5.5h-1a.5.5,0,0,1-.5-.5v-1a.5.5,0,0,1,.5-.5"
                                    transform="translate(23.966 529)" fill="#b5b5bf" />
                                <path id="Path_2957" data-name="Path 2957"
                                    d="M7.5,27.963h1a.5.5,0,0,1,.5.5v1a.5.5,0,0,1-.5.5h-1a.5.5,0,0,1-.5-.5v-1a.5.5,0,0,1,.5-.5"
                                    transform="translate(23.966 526)" fill="#b5b5bf" />
                                <path id="Path_2958" data-name="Path 2958"
                                    d="M13.5,16.963h5a.5.5,0,0,1,0,1h-5a.5.5,0,0,1,0-1"
                                    transform="translate(20.966 531.5)" fill="#b5b5bf" />
                                <path id="Path_2959" data-name="Path 2959"
                                    d="M13.5,22.963h5a.5.5,0,0,1,0,1h-5a.5.5,0,0,1,0-1"
                                    transform="translate(20.966 528.5)" fill="#b5b5bf" />
                                <path id="Path_2960" data-name="Path 2960"
                                    d="M13.5,28.963h5a.5.5,0,0,1,0,1h-5a.5.5,0,0,1,0-1"
                                    transform="translate(20.966 525.5)" fill="#b5b5bf" />
                            </g>
                        </svg>
                        <span class="crea-side-nav-text ml-3">{{ translate('Purchase History') }}</span>
                        @if ($delivery_viewed > 0 || $payment_status_viewed > 0)
                            <span class="badge badge-inline badge-success">{{ translate('New') }}</span>
                        @endif
                    </a>
                </li>

                <li class="crea-side-nav-item">
                    <a href="{{ route('wishlists.index') }}"
                        class="crea-side-nav-link {{ areActiveRoutes(['wishlists.index']) }}">
                        <svg id="Group_8116" data-name="Group 8116" xmlns="http://www.w3.org/2000/svg"
                            xmlns:xlink="http://www.w3.org/1999/xlink" width="16" height="14"
                            viewBox="0 0 16 14">
                            <defs>
                                <clipPath id="clip-path">
                                    <rect id="Rectangle_1391" data-name="Rectangle 1391" width="16" height="14"
                                        fill="#b5b5bf" />
                                </clipPath>
                            </defs>
                            <g id="Group_8115" data-name="Group 8115" clip-path="url(#clip-path)">
                                <path id="Path_2981" data-name="Path 2981"
                                    d="M14.682,1.318a4.5,4.5,0,0,0-6.364,0L8,1.636l-.318-.318A4.5,4.5,0,0,0,1.318,7.682l6.046,6.054a.9.9,0,0,0,1.273,0l6.045-6.054a4.5,4.5,0,0,0,0-6.364m-.707,5.657L8,12.959,2.025,6.975a3.5,3.5,0,0,1,4.95-4.95l.389.389a.9.9,0,0,0,1.273,0l.388-.389a3.5,3.5,0,0,1,4.95,4.95"
                                    transform="translate(0 0)" fill="#b5b5bf" />
                            </g>
                        </svg>
                        <span class="crea-side-nav-text ml-3">{{ translate('Wishlist') }}</span>
                    </a>
                </li>

                <!-- Manage Profile -->
                <li class="crea-side-nav-item">
                    <a href="{{ route('profile') }}" class="crea-side-nav-link {{ areActiveRoutes(['profile']) }}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                            <g id="Group_8094" data-name="Group 8094" transform="translate(3176 -602)">
                                <path id="Path_2924" data-name="Path 2924"
                                    d="M331.144,0a4,4,0,1,0,4,4,4,4,0,0,0-4-4m0,7a3,3,0,1,1,3-3,3,3,0,0,1-3,3"
                                    transform="translate(-3499.144 602)" fill="#b5b5bf" />
                                <path id="Path_2925" data-name="Path 2925"
                                    d="M332.144,20h-10a3,3,0,0,0,0,6h10a3,3,0,0,0,0-6m0,5h-10a2,2,0,0,1,0-4h10a2,2,0,0,1,0,4"
                                    transform="translate(-3495.144 592)" fill="#b5b5bf" />
                            </g>
                        </svg>
                        <span class="crea-side-nav-text ml-3">{{ translate('Manage Profile') }}</span>
                    </a>
                </li>
                <!-- Delete My Account -->
                <li class="crea-side-nav-item">
                    <a href="javascript:void(0)"
                        onclick="account_delete_confirm_modal('{{ route('account_delete') }}')"
                        class="crea-side-nav-link">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                            <g id="Group_25000" data-name="Group 25000" transform="translate(-240.535 -537)">
                                <path id="Path_2961" data-name="Path 2961"
                                    d="M221.069,0a8,8,0,1,0,8,8,8,8,0,0,0-8-8m0,15a7,7,0,1,1,7-7,7,7,0,0,1-7,7"
                                    transform="translate(27.466 537)" fill="#b5b5bf" />
                                <rect id="Rectangle_18942" data-name="Rectangle 18942" width="8" height="1"
                                    rx="0.5" transform="translate(244.535 544.5)" fill="#b5b5bf" />
                            </g>
                        </svg>
                        <span class="crea-side-nav-text ml-3">{{ translate('Delete My Account') }}</span>
                    </a>
                </li>
            </ul>
            <!-- logout -->
            <a href="{{ route('logout') }}" class="btn btn-primary btn-block fs-14 fw-700 mb-5 mb-md-0"
                style="border-radius: 25px;">{{ translate('Sign Out') }}</a>
        </div>
    </div>
</div>
