@php
    $events_carousel = [
        [
            'image' => 'assets/img/concerts.webp',
            'title' => translate('Concerts & Festivals'),
            'subtitle' => translate('Feel the rhythm of the greatest artists.'),
        ],
        [
            'image' => 'assets/img/matchs.webp',
            'title' => translate('Matches & Sports Competitions'),
            'subtitle' => translate('Book your spot and support your team.'),
        ],
        [
            'image' => 'assets/img/spectacles.webp',
            'title' => translate('Shows & Theatres'),
            'subtitle' => translate('Enjoy an immersive evening.'),
        ],
        [
            'image' => 'assets/img/formations.webp',
            'title' => translate('Conferences & Training'),
            'subtitle' => translate('evelop your knowledge and expand your network.'),
        ],
    ];

    $deals_carousel = [
        [
            'image' => 'assets/img/restauration.webp',
            'title' => translate('Dining & Gastronomy'),
            'subtitle' => translate('Taste your favorite dishes at reduced prices.'),
        ],
        [
            'image' => 'assets/img/voyages.webp',
            'title' => translate('Travel & Stays'),
            'subtitle' => translate('Enjoy hotels and getaways at exclusive rates.'),
        ],
        [
            'image' => 'assets/img/activites.webp',
            'title' => translate('Activities & Leisure'),
            'subtitle' => translate('Explore new unforgettable experiences.'),
        ],
        [
            'image' => 'assets/img/shopping.webp',
            'title' => translate('Shopping & E-commerce'),
            'subtitle' => translate('Buy your favorite brands with exclusive discounts.'),
        ],
    ];
@endphp

<div id="landingpage-events-deals">
    <div class="container">
        <div class="row evnets-tickets">
            <div class="col-md-6 pullright">

                <div class="wolholder">
                    <h2>{{ translate('Events & Ticketing: Experience 100%!') }}</h2>

                    <p>{{ translate('Select, reserve and receive your ticket instantly!') }}</p>

                    <a class="btn btn-outline"
                        href="{{ route('home', ['type' => 'event']) }}">{{ translate('See all events') }}</a>
                </div>

            </div>
            <div class="col-md-6 ">
                <div class="crea-carousel-cat-group sm-gutters-8" data-items="3" data-xl-items="3" data-lg-items="3"
                    data-md-items="1" data-sm-items="1" data-xs-items="1" data-arrows='true' data-dots='true'
                    data-infinite="true">
                    @foreach ($events_carousel as $key => $event)
                        <div class="carousel-box px-2 position-relative">
                            @include('frontend.partials.boxes.category_box_3', ['category' => $event])
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
        <div class="row row-reverse-mob deals-offers">
            <div class="col-md-6">
                <div class="crea-carousel-cat-group sm-gutters-8" data-items="3" data-xl-items="3" data-lg-items="3"
                    data-md-items="1" data-sm-items="1" data-xs-items="1" data-arrows='true' data-dots='true'
                    data-infinite="true">
                    @foreach ($deals_carousel as $key => $deal)
                        <div class="carousel-box px-2 position-relative">
                            @include('frontend.partials.boxes.category_box_3', ['category' => $deal])
                        </div>
                    @endforeach
                </div>
            </div>
            <div class="col-md-6 pulleft">
                <h2>{{ translate('Deals & Special Offers: Seize the Best Opportunities!') }}</h2>

                <p>{{ translate('Deals are limited, take advantage before it\'s too late!') }}</p>

                <a class="btn btn-outline"
                    href="{{ route('home', ['type' => 'deal']) }}">{{ translate('See all deals') }}</a>
            </div>
        </div>
    </div>
</div>
