@extends('frontend.layouts.app')

@section('content')
    <section class="py-4">
        <div class="container text-left">
            <div class="row">
                <div class="col-xl-8 mx-auto">
                    @php
                        $first_order = $combined_order->orders->first();
                    @endphp

                    <div class="text-center my-4 mb-0">
                        <img src="{{ static_asset('assets/img/payment-success.webp') }}">
                        <h2>{{ translate('Congratulations... Your Payment Was Successfully Processed!') }}</h2>
                        <p>{{ translate('You will receive an email shortly with all the details of your purchase.') }}
                        </p>

                        <div class="row col-success-pay">
                            <div class="col-md-5">
                                <div class="info-box">
                                    <img src="{{ static_asset('assets/img/email-confirm.webp') }}">
                                    <span>
                                        {{ translate('A confirmation email has just been sent to you.') }}
                                    </span>
                                </div>
                            </div>

                            <div class="col-md-2"><img src="{{ static_asset('assets/img/ou.webp') }}"></div>

                            <div class="col-md-5">
                                <div class="info-box">
                                    <img src="{{ static_asset('assets/img/consult.webp') }}">
                                    <span>
                                        {{ translate('Check out our latest deals and events.') }}
                                 
                                        {{ translate('View My Orders') }}
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row my-3 p-4 bg-white">
                        @php
                            $product = $first_order->orderDetails->first()->product;
                            $event = [];
                            $event['title'] = $product->name;
                            $event['location'] = $product->event_city;
                            $event['start_date'] = $product->event_start_date;
                            $event['end_date'] = $product->event_end_date;
                        @endphp
                        <div class="col-md-6">
                            <h5>{{ translate('Order Information') }}</h5>
                            <table class="table table-striped fs-14 text-soft-dark">
                                <tr>
                                    <td class="w-50 fw-600 border-top-0 pl-0 py-2">{{ translate('Name') }}:
                                    </td>
                                    <td class="border-top-0 py-2">
                                        {{ json_decode($first_order->shipping_address)->name }}</td>
                                </tr>
                                <tr>
                                    <td class="w-50 fw-600 border-top-0 pl-0 py-2">{{ translate('Email') }}:
                                    </td>
                                    <td class="border-top-0 py-2">
                                        {{ json_decode($first_order->shipping_address)->email }}</td>
                                </tr>
                                <tr>
                                    <td class="w-50 fw-600 border-top-0 pl-0 py-2">{{ translate('Phone') }}:
                                    </td>
                                    <td class="border-top-0 py-2">
                                        {{ json_decode($first_order->shipping_address)->phone }}</td>
                                </tr>
                                <tr>
                                    <td class="w-50 fw-600 border-top-0 pl-0 py-2">{{ translate('Address') }}:
                                    </td>
                                    <td class="border-top-0 py-2">
                                        {{ json_decode($first_order->shipping_address)->address }}</td>
                                </tr>
                                <tr>
                                    <td class="w-50 fw-600 border-top-0 pl-0 py-2">{{ translate('City') }}:
                                    </td>
                                    <td class="border-top-0 py-2">
                                        {{ json_decode($first_order->shipping_address)->city }}</td>
                                </tr>
                                <tr>
                                    <td class="w-50 fw-600 border-top-0 pl-0 py-2">{{ translate('Name') }}:
                                    </td>
                                    <td class="border-top-0 py-2">
                                        {{ $product->name }}
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            {{ generate_event_qrcode($event) }}

                            <p>{{ translate('Scan me to add me to your calendar!') }}</p>
                        </div>
                    </div>

                    <div class="row my-4">
                        <div class="col-md-12">
                            <a class="btn btn-outline" href="{{ route('home') }}">{{ translate('Back to home page') }}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('script')
    @if (get_setting('facebook_pixel') == 1)
        <!-- Facebook Pixel purchase Event -->
        <script>
            $(document).ready(function() {
                var currend_code = '{{ get_system_currency()->code }}';
                var amount = 'single_price($combined_order->grand_total) }}';
                fbq('track', 'Purchase', {
                    value: amount,
                    currency: currend_code,
                    content_type: 'product'
                });
            });
        </script>
        <!-- Facebook Pixel purchase Event -->
    @endif
@endsection
