@extends('frontend.layouts.app')

@section('meta_title'){{ $page->meta_title }}@stop

@section('meta_description'){{ $page->meta_description }}@stop

@section('meta_keywords'){{ $page->tags }}@stop

@section('meta')
    <!-- Schema.org markup for Google+ -->
    <meta itemprop="name" content="{{ $page->meta_title }}">
    <meta itemprop="description" content="{{ $page->meta_description }}">
    <meta itemprop="image" content="{{ uploaded_asset($page->meta_image) }}">

    <!-- Twitter Card data -->
    <meta name="twitter:card" content="website">
    <meta name="twitter:site" content="@publisher_handle">
    <meta name="twitter:title" content="{{ $page->meta_title }}">
    <meta name="twitter:description" content="{{ $page->meta_description }}">
    <meta name="twitter:creator" content="@author_handle">
<meta name="twitter:image" content="{{ uploaded_asset($page->meta_image) }}">

<!-- Open Graph data -->
<meta property="og:title" content="{{ $page->meta_title }}" />
<meta property="og:type" content="website" />
<meta property="og:url" content="{{ URL($page->slug) }}" />
<meta property="og:image" content="{{ uploaded_asset($page->meta_image) }}" />
<meta property="og:description" content="{{ $page->meta_description }}" />
<meta property="og:site_name" content="{{ env('APP_NAME') }}" />
@endsection

@section('content')
<div class="page-wrapper">
    {{-- Breadcrumb --}}
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <ul
                    class="product-breadcrumb breadcrumb align-items-baseline justify-content-center justify-content-lg-start bg-transparent p-0">
                    <li class="breadcrumb-item has-transition opacity-60 hov-opacity-100">
                        <a class="text-reset" href="{{ route('home') }}">{{ translate('Home') }}</a>
                    </li>
                    <li class="breadcrumb-item">
                        <span>{{ $page->getTranslation('title') }}</span>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="row">
            @if ('' != $page->form)
            <div class="col-md-6">
                @include('frontend.forms.' . $page->form)
            </div>
            @endif

            <div class="col  @if('' == $page->form) bg-white p-5 mb-4 @endif">
                <div class="page-content">
                    {!! $page->getTranslation('content') !!}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
@if (get_setting('google_recaptcha') == 1)
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
@endif

<script type="text/javascript">
    @if (get_setting('google_recaptcha') == 1)
        // making the CAPTCHA  a required field for form submission
        $(document).ready(function () {
            $("#reg-form").on("submit", function (evt) {
                var response = grecaptcha.getResponse();
                if (response.length == 0) {
                    //reCaptcha not verified
                    alert("please verify you are human!");
                    evt.preventDefault();
                    return false;
                }
                //captcha verified
                //do the rest of your validations here
                $("#reg-form").submit();
            });
        }); @endif
        </script>
@endsection
