<div class="modal fade" id="account_modal" tabindex="-1" role="dialog" aria-labelledby="account_modal_label"

    aria-hidden="true">

    <div class="modal-dialog modal-xl modal-dialog-zoom" role="document">

        <div class="container">

            <div class="row">

                <span class="or-tag">{{ translate('OR') }}</span>

                <div class="col-md-6">

                    <div class="modal-content login-modal">

                        <div class="modal-header">

                            <h6 class="modal-title fw-600">{{ translate('CONNEXION') }}</h6>

                        </div>

                        <div class="modal-body">

                            <div class="p-3">

                                <form class="form-default" role="form" action="{{ route('profile.login') }}"

                                    method="POST">

                                    @csrf



                                    {{-- Email --}}

                                    <div class="form-group">

                                        <input type="email"

                                            class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}"

                                            value="{{ old('email') }}" placeholder="{{ translate('Email') }}"

                                            name="email" id="email" autocomplete="off">

                                        @if ($errors->has('email'))

                                            <span class="invalid-feedback" role="alert">

                                                <strong>{{ $errors->first('email') }}</strong>

                                            </span>

                                        @endif

                                    </div>



                                    {{-- Password --}}

                                    <div class="form-group">

                                        <input type="password" name="password"

                                            class="form-control h-auto rounded-0 form-control-lg"

                                            placeholder="{{ translate('Password') }}">

                                    </div>



                                    {{-- Remember me & forgot password --}}

                                    <div class="row mb-2">

                                        <div class="col-6">

                                            <label class="crea-checkbox">

                                                <input type="checkbox" name="remember"

                                                    {{ old('remember') ? 'checked' : '' }}>

                                                <span class=opacity-60>{{ translate('Remember Me') }}</span>

                                                <span class="crea-square-check"></span>

                                            </label>

                                        </div>

                                        <div class="col-6 text-right">

                                            <a href="{{ route('password.request') }}"

                                                class="text-reset opacity-60 hov-opacity-100 fs-14">{{ translate('Forgot password?') }}</a>

                                        </div>

                                    </div>



                                    {{-- Login button --}}

                                    <div class="mb-5">

                                        <button type="submit"

                                            class="btn btn-primary btn-block fw-600 rounded-0">{{ translate('Connexion') }}</button>

                                    </div>

                                </form>



                                <div class="separator mb-3">

                                    <span class="bg-white px-3 opacity-60">{{ translate('Or Login With') }}</span>

                                </div>



                                <ul class="list-inline social colored text-center mb-5">

                                    {{-- Google --}}

                                    {{-- @if (get_setting('google_login') == 1) --}}

                                    <li class="list-inline-item">

                                        <a href="{{ route('social.login', ['provider' => 'google']) }}" class="google">

                                            <i class="lab la-google"></i>

                                        </a>

                                    </li>

                                    {{-- @endif --}}

                                </ul>



                            </div>

                        </div>

                    </div>

                </div>

                <div class="col-md-6">

                    <div class="modal-content register-modal">

                        <div class="modal-header">

                            <h6 class="modal-title">{{ translate('NEW ACCOUNT') }}</h6>

                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                                <span aria-hidden="true">&times;</span>

                            </button>

                        </div>



                        <div class="modal-body">

                            <div class="p-3">

                                <form class="form-default" role="form" action="{{ route('profile.register') }}"

                                    method="POST">

                                    @csrf



                                    <div class="row">

                                        <div class="col-md-6">

                                            {{-- First name --}}

                                            <div class="form-group">

                                                <input type="text" name="first_name" id="first_name"

                                                    class="form-control"

                                                    placeholder="{{ translate('Your first name') }}" required>

                                            </div>

                                        </div>

                                        <div class="col-md-6">

                                            {{-- Last name --}}

                                            <div class="form-group">

                                                <input type="text" name="last_name" id="last_name"

                                                    class="form-control"

                                                    placeholder="{{ translate('Your last name') }}" required>

                                            </div>

                                        </div>

                                    </div>



                                    <div class="row">

                                        <div class="col-md-6">

                                            {{-- Email --}}

                                            <div class="form-group">

                                                <input type="email" name="email" id="email" class="form-control"

                                                    placeholder="{{ translate('Your Email') }}" required>

                                            </div>

                                        </div>

                                        <div class="col-md-6">

                                            {{-- Phone Number --}}

                                            <div class="form-group">

                                                <input type="tel" name="phone" id="phone"

                                                    class="form-control"

                                                    placeholder="{{ translate('Your phone number') }}" required>

                                            </div>

                                        </div>

                                    </div>



                                    <div class="row">

                                        <div class="col-md-6">

                                            {{-- Address --}}

                                            <div class="form-group">

                                                <input type="text" name="address" id="address"

                                                    class="form-control"

                                                    placeholder="{{ translate('Your address') }}" required>

                                            </div>

                                        </div>

                                        <div class="col-md-6">

                                            {{-- City --}}

                                            <div class="form-group">

                                                <input type="text" name="city" id="city"

                                                    class="form-control" placeholder="{{ translate('Your city') }}"

                                                    required>

                                            </div>

                                        </div>

                                    </div>



                                    <div class="row">

                                        <div class="col-md-6">

                                            {{-- Password --}}

                                            <div class="form-group">

                                                <input type="password" name="password" id="password"

                                                    class="form-control"

                                                    placeholder="{{ translate('Your password') }}" required>

                                            </div>

                                        </div>

                                        <div class="col-md-6">

                                            {{-- Confirm Password --}}

                                            <div class="form-group">

                                                <input type="password" name="password_confirmation"

                                                    id="password_confirmation" class="form-control"

                                                    placeholder="{{ translate('Confirm password') }}">

                                            </div>

                                        </div>

                                    </div>



                                    {{-- Register button --}}

                                    <div class="mb-5">

                                        <button type="submit"

                                            class="btn btn-primary btn-block fw-600 rounded-0">{{ translate('Inscription') }}</button>

                                    </div>

                                </form>



                                <div class="separator mb-3">

                                    <span class="bg-white px-3 opacity-60">{{ translate('Or Login With') }}</span>

                                </div>



                                <ul class="list-inline social colored text-center mb-5">

                                    {{-- Google --}}

                                    {{-- @if (get_setting('google_login') == 1) --}}

                                    <li class="list-inline-item">

                                        <a href="{{ route('social.login', ['provider' => 'google']) }}"

                                            class="google">

                                            <i class="lab la-google"></i>

                                        </a>

                                    </li>

                                    {{-- @endif --}}

                                </ul>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

