@php
    $information = [
        [
            'icon' => 'assets/img/payment.png',
            'title' => translate('Secure payment'),
            'description' => translate('shop with confidence. Your data is in safe hands with us.'),
        ],
        [
            'icon' => 'assets/img/support.png',
            'title' => translate('Support 24/7'),
            'description' => translate('With our 7/24 support, you\'re never alone. We\'re there for you, day and night!'),
        ],
        [
            'icon' => 'assets/img/discounts.png',
            'title' => translate('Special offers'),
            'description' => translate('Don\'t miss the chance to save money and experience unique moments. Buy your deals and tickets now!'),
        ],
        [
            'icon' => 'assets/img/app.png',
            'title' => translate('Store on the go!'),
            'description' => translate('Shop wherever you are, whenever you want, directly from your smartphone.'),
        ],
    ];
@endphp

<div class="general-information-block">
    <div class="row">
        @foreach ($information as $info)
            <div class="col-md-3">
                <div class="card text-center">
                    <img class="m-auto" width="65" src="{{ static_asset($info['icon']) }}">
                    <div class="card-body">
                        <h5 class="card-title">{{ $info['title'] }}</h5>
                        <p class="card-text">{{ $info['description'] }}</p>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
</div>
