@php
    $cart_added = [];

    $type = $product->type;
    $timestamp = $product->event_end_date;
    $s_date = new DateTime("@$product->event_start_date");
    $_date = new DateTime("@$timestamp");
    $currentDate = new DateTime();

    $class = '';
    $badge = '';
    if ($_date < $currentDate || 0 == $product->stocks->first()->qty) {
        if (0 == $product->stocks->first()->qty) {
            $class = 'sold-out';
            $badge = translate('Sold Out');
        } else {
            $class = 'over';
            $badge = translate('Offre is over');
        }
    }
@endphp
<div class="crea-card-box product-box-1 h-auto bg-white {{ $class }}">

    <div class="position-relative img-fit overflow-hidden">
        <a href="javascript:void(0)" class="hov-svg-white @if(in_wishlists($product->id)) active @endif" onclick="addToWishList({{ $product->id }})"
            data-toggle="tooltip" data-title="{{ translate('Add to wishlist') }}" data-placement="left">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="14.4" viewBox="0 0 16 14.4">
                <g id="_51a3dbe0e593ba390ac13cba118295e4" data-name="51a3dbe0e593ba390ac13cba118295e4"
                    transform="translate(-3.05 -4.178)">
                    <path id="Path_32649" data-name="Path 32649"
                        d="M11.3,5.507l-.247.246L10.8,5.506A4.538,4.538,0,1,0,4.38,11.919l.247.247,6.422,6.412,6.422-6.412.247-.247A4.538,4.538,0,1,0,11.3,5.507Z"
                        transform="translate(0 0)" fill="#919199" />
                    <path id="Path_32650" data-name="Path 32650"
                        d="M11.3,5.507l-.247.246L10.8,5.506A4.538,4.538,0,1,0,4.38,11.919l.247.247,6.422,6.412,6.422-6.412.247-.247A4.538,4.538,0,1,0,11.3,5.507Z"
                        transform="translate(0 0)" fill="#919199" />
                </g>
            </svg>
        </a>
        @if ('' != $badge)
            <span class="re-ribbon-badge left-badge"><span>{{ $badge }}</span></span>
        @endif

        @php
            $product_url = route('product', $product->slug);
        @endphp
        <!-- Image -->
        <a href="{{ $product_url }}" class="d-block h-100">
            <img class="lazyload mx-auto img-fit has-transition" src="{{ get_image($product->thumbnail) }}"
                alt="{{ $product->getTranslation('name') }}" title="{{ $product->getTranslation('name') }}"
                onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';">
        </a>
    </div>
    <div class="p-2 p-md-3 text-left txtbx">
        {{-- Product Name --}}
        <h3 class="fw-400 fs-13 text-truncate-2 lh-1-4 mb-0  text-left mt-3 mb-2">
            <a href="{{ $product_url }}" class="d-block text-reset hov-text-primary"
                title="{{ $product->getTranslation('name') }}">{{ $product->getTranslation('name') }}</a>
        </h3>

        <div class="product-location-countdown">
            {{-- Location --}}
            @if ($product->city)
                <div class="row mt-1">
                    <div class="col-md-12 markerholder">
                        <span><img class="localprd" src="{{ static_asset('assets/img/location.webp') }}"></span>
                        <span class="cityblock">{{ optional($product->city)->getTranslation('name') }}</span>
                    </div>
                </div>
            @endif

            {{-- Countdown --}}
            @if ('' !== $product->event_start_date)
                @if ($s_date > $currentDate)
                    <div class="d-flex align-items-center mb-1">
                        <span><img class="timeprd" src="{{ static_asset('assets/img/time.webp') }}"></span>
                        <span>
                            <div class="crea-count-down-box align-items-center"
                                data-date="{{ date('Y/m/d H:i:s', $product->event_start_date) }}">
                            </div>
                        </span>
                    </div>
                @endif
            @endif
        </div>

        {{-- Product Price & Rating --}}
        <div class="row labelrow">
            <div class="col-md-6 halfgridprice pricecol col-sm-6 col-xs-6">
                <span class="price-label text-primary">{{ translate('Just') }}</span>
                <span class="fw-700 text-primary">
                    {!! home_discounted_base_price($product) !!}
                </span>
            </div>
            <div class="col-md-6 halfgridprice labcol col-sm-6 col-xs-6">
                <div class="row">
                    @php
                        $rating = $product->rating > 0 ? $product->rating : $product->default_reviews_stars;
                    @endphp
                    <div class="col-12 text-right">
                        @if (0 < $rating)
                            <span class="rating">
                                {{ renderStarRating($rating) }}
                            </span>
                        @endif
                    </div>
                    <div class="col-12 text-right mb-1">
                        @if (0 < $product->default_sales)
                            @if (1 == $product->default_sales)
                                {{ $product->default_sales }} {{ translate('buyer') }}
                            @else
                                @if (10 > $product->default_sales)
                                    {{ $product->default_sales }} {{ translate('buyers') }}
                                @else
                                    +{{ $product->default_sales }} {{ translate('buyers') }}
                                @endif
                            @endif
                        @endif
                    </div>
                </div>
            </div>
        </div>

        {{-- Buy now button --}}
        <div class="text-center">
            <a class="btn btn-warning" href="{{ $product_url }}">
                <span class="cart-btn-text">
                    @if ($_date < $currentDate || 0 == $product->stocks->first()->qty)
                        {{ translate('Sold Out') }}
                    @else
                        {{ translate('Buy Now') }}
                    @endif
                </span>
            </a>
        </div>
    </div>
</div>
