@php
    // if ('fr' == app()->getLocale()) {
    //     setlocale(LC_ALL, 'fr_FR.UTF-8');
    // } elseif ('ma' == app()->getLocale()) {
    //     setlocale(LC_ALL, 'ar_MA.UTF-8');
    // } else {
    //     setlocale(LC_ALL, 'en_EN.UTF-8');
    // }

    // Set locale based on the application locale
    if ('fr' == app()->getLocale()) {
        $locale = 'fr_FR';
    } elseif ('ma' == app()->getLocale()) {
        $locale = 'ar_MA';
    } else {
        $locale = 'en_US'; // Use 'en_US' instead of 'en_EN'
    }

    // Convert Unix timestamp to DateTime object
    $event_start_date = (new DateTime())->setTimestamp($product->event_start_date);

    // Create date and time formatters
    $dateFormatter = new IntlDateFormatter($locale, IntlDateFormatter::FULL, IntlDateFormatter::NONE);
    $timeFormatter = new IntlDateFormatter($locale, IntlDateFormatter::NONE, IntlDateFormatter::SHORT);

    // Format the date and time according to the locale
    $date = $dateFormatter->format($event_start_date);
    $hour = $timeFormatter->format($event_start_date);

    $product_url = route('product', $product->slug);
    $rating = $product->rating > 0 ? $product->rating : $product->default_reviews_stars;
    // $date = strftime('%A %d %B %Y', $product->event_start_date);
    // $hour = strftime('%H:%M', $product->event_start_date);
@endphp

<div class="crea-card-box product-box-3 bg-white">
    <div class="row directionrtl">
        <div class="col-md-5">
            <img class="img-fit" src="{{ get_image($product->featuredImage) }}"
                alt="{{ $product->getTranslation('name') }}">
        </div>
        <div class="col-md-7">
            <div class="row">
                <div class="col-9">
                    {{-- Product Name --}}
                    <h3 class="fw-400 fs-13 text-truncate-2 lh-1-4 mb-0  text-left mt-3 mb-2">
                        <a href="{{ $product_url }}" class="d-block text-reset hov-text-primary"
                            title="{{ $product->getTranslation('name') }}">{{ $product->getTranslation('name') }}</a>
                    </h3>

                    {{-- Rating --}}
                    <div class="row">
                        <div class="col-12">
                            @if (0 < $rating)
                                <span class="rating">
                                    {{ renderStarRating($rating) }}
                                </span>
                            @endif
                        </div>
                    </div>

                    {{-- Price --}}
                    <div class="row">
                        <div class="col-12">
                            {!! home_discounted_base_price($product) !!}
                        </div>
                    </div>

                    <ul>
                        <li>{{ $date }}</li>
                        <li>{{ optional($product->city)->getTranslation('name') }}</li>
                        <li>{{ translate('Door opening at ') }} {{ $hour }}</li>
                    </ul>
                </div>
                <div class="col-3">
                    @if ('' != product_discount_value($product))
                        <div class="product-discount">
                            <img src="{{ static_asset('assets/img/discount-icon.png') }}" alt="">
                            <span>
                                {{ translate('Discount of') }}
                            </span>
                            <span>
                                {!! product_discount_value($product) !!}
                            </span>
                        </div>
                    @endif
                </div>
            </div>

            <div class="leftcountbox row">
                <div class="col-12">
                    <div id="product-sales-bar">
                        <span
                            style="width: {{ ($product->orderDetails->sum('quantity') / $product->stocks->first()->qty) * 100 }}%;"></span>
                    </div>
                </div>
                <div class="col-12">
                    
                    <span class="sold-value">
                        @if ($product->orderDetails->sum('quantity') < $product->stocks->first()->qty )
                            {{ $product->orderDetails->sum('quantity') }}/{{ $product->stocks->first()->qty }}
                        @else
                            {{ $product->stocks->first()->qty }}/{{ $product->stocks->first()->qty }}
                        @endif
                    </span>
                    <span class="sold-label">
                        {{ translate('Tickets') }}
                    </span>
                    <span class="sold-label">
                        {{ translate('has been sold') }}
                    </span>
                </div>
            </div>

            {{-- Buy now button --}}
            <div class="row">
                <div class="col-12">
                    <div class="text-center">
                        <a class="btn btn-warning btn-block" href="{{ $product_url }}">
                            <span class="cart-btn-text">
                                @if (0 == $product->stocks->first()->qty)
                                    {{ translate('Sold Out') }}
                                @else
                                    {{ translate('Buy Now') }}
                                @endif
                            </span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
