@php
$product_url = route('product', $product->slug);
$rating = $product->rating > 0 ? $product->rating : $product->default_reviews_stars;
@endphp

<div class="crea-card-box product-box-4 h-auto bg-white">
    <div class="row">
        <div class="col-md-4">
            <a href="{{ $product_url }}" class="d-block h-100">
                <img class="lazyload mx-auto img-fit has-transition" src="{{ get_image($product->featuredImage) }}"
                    alt="{{ $product->getTranslation('name') }}" title="{{ $product->getTranslation('name') }}"
                    onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';">
            </a>
        </div>
        <div class="col-md-8">
            {{-- Product Name --}}
            <h3 class="fw-400 fs-13 text-truncate-2 lh-1-4 mb-0  text-left mt-3 mb-2">
                <a href="{{ $product_url }}" class="d-block text-reset hov-text-primary"
                    title="{{ $product->getTranslation('name') }}">{{ $product->getTranslation('name') }}</a>
            </h3>
            {{-- Rating --}}
            <div class="row">
                <div class="col-12">
                    @if (0 < $rating) <span class="rating">
                        {{ renderStarRating($rating) }}
                        </span>
                        @endif
                </div>
            </div>

            {{-- Price --}}
            <div class="row">
                <div class="col-12">
                    {!! home_discounted_base_price($product) !!}
                </div>
            </div>

            {{-- Discount --}}
            <div class="product-discount">
                <img src="{{ static_asset('assets/img/discount-icon.png') }}" alt="">
                <span>
                    {{ translate('Discount of') }}
                </span>
                <span>
                    {!! product_discount_value($product) !!}
                </span>
            </div>
        </div>
    </div>
</div>