<style>
    #mini-cart-wrapper {
        position: relative;
    }

    .mini-cart-overlay {
        position: fixed;
        z-index: 9990;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, .65);
    }

    .mini-cart {
        position: fixed;
        z-index: 9999;
        top: 0;
        right: 0;
        width: 300px;
        height: 100%;
        background-color: #fff;
    }
</style>

<div id="mini-cart-wrapper" style="display: none;">
    <div class="mini-cart-overlay">

    </div>
    <div id="mini-cart" class="mini-cart">
        <div class="position-relative">
            <div class="mini-cart-header">
                <span>{{ translate('Cart') }}</span>

                <button id="mini-cart-close-btn">
                    <i class="fa fa-times"></i>
                </button>
            </div>

            <div class="mini-cart-content">
                <ul class="overflow-auto c-scrollbar-light list-group list-group-flush mx-1">
                    @foreach ($carts as $key => $cartItem)
                        @php
                            $product = get_single_product($cartItem['product_id']);
                        @endphp

                        @if (null != $product)
                            <li class="list-group-item border-0 hov-scale-img">
                                <span class="d-flex align-items-center">
                                    <img src="{{ static_asset('assets/img/placeholder.jpg') }}"
                                        data-src="{{ uploaded_asset($product->thumbnail_img) }}"
                                        class="img-fit lazyload size-60px has-transition"
                                        alt="{{ $product->getTranslation('name') }}"
                                        onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';">
                                    <span class="minw-0 pl-2 flex-grow-1">
                                        <span class="fw-700 fs-13 text-dark mb-2 text-truncate-2"
                                            title="{{ $product->getTranslation('name') }}">
                                            {{ $product->getTranslation('name') }}
                                        </span>

                                        <div class="d-flex justify-content-between">
                                            {{-- <div class="d-flex align-items-center crea-plus-minus mr-0 ml-0">
                                                <button class="btn col-auto btn-icon btn-sm btn-light rounded-0"
                                                    type="button" data-type="minus"
                                                    data-field="quantity[{{ $cartItem->id }}]">
                                                    <i class="las la-minus"></i>
                                                </button>
                                                <input type="number" name="quantity[{{ $cartItem->id }}]"
                                                    class="col border-0 text-center px-0 fs-14 input-number"
                                                    placeholder="1" value="{{ $cartItem['quantity'] }}"
                                                    min="{{ $product->min_qty }}"
                                                    max="{{ $product->stocks->first()->qty }}"
                                                    onchange="updateQuantity({{ $cartItem->id }}, this)"
                                                    style="min-width: 45px;">
                                                <button class="btn col-auto btn-icon btn-sm btn-light rounded-0"
                                                    type="button" data-type="plus"
                                                    data-field="quantity[{{ $cartItem->id }}]">
                                                    <i class="las la-plus"></i>
                                                </button>
                                            </div> --}}
                                            <span class="fs-14 fw-400 text-secondary">{!! mini_cart_product_price($cartItem, $product) !!}</span>

                                            <button type="button" onclick="removeFromCart({{ $cartItem['id'] }})"
                                                class="btn btn-sm btn-icon stop-propagation">
                                                <i class="la la-trash fs-18 fw-600 text-secondary"></i>
                                            </button>
                                        </div>

                                    </span>
                                </span>
                            </li>
                        @endif
                    @endforeach
                </ul>
            </div>

            <div class="mini-cart-footer">
                <div class="mini-cart-total">
                    <span>{{ translate('Total') }}</span>
                    <span>{!! single_price($total) !!}</span>
                </div>

                <div class="mini-cart-btns">
                    <a class="mini-cart-btn" href="{{ route('cart') }}">{{ translate('View Cart') }}</a>
                    <a class="mini-cart-btn" href="{{ route('checkout') }}">{{ translate('Complete my order') }}</a>
                </div>
            </div>
        </div>
    </div>
</div>
