@if (count($featured_categories) > 0)
    <section class="categories-sec">
        <div class="container">
            <!-- Categories -->
            <div>
                <div class="d-flex">
                    <div class=" px-0 cat-item first-item-cat">
                        <div class=" text-center ">
                            <div class="px-0">
                                <span class="text-dark mb-0  text-truncate-2">
                                    <a href="{{ route('home') }}/category/new-in" title="New in">
                                        {{ translate('NEW IN') }}
                                    </a>
                                </span>
                            </div>
                        </div>
                    </div>
                    @foreach ($featured_categories->take(7) as $key => $category)
                        @php
                            $category_name = $category->getTranslation('name');
                        @endphp
                        <div class=" px-0 cat-item ">
                            <div class=" itemhold text-center ">
                                <div>
                                    <a href="{{ route('products.category', $category->slug) }}"
                                        title="{{ $category_name }}"> <img
                                            src="{{ isset($category->bannerImage->file_name) ? my_asset($category->bannerImage->file_name) : static_asset('assets/img/placeholder.jpg') }}"
                                            class="lazyload h-auto mx-auto has-transition"
                                            alt="{{ $category->getTranslation('name') }}"
                                            onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';"></a>
                                </div>
                                <div class="px-0">
                                    <span class="text-dark mb-0 text-truncate-2">
                                        <a href="{{ route('products.category', $category->slug) }}"
                                            title="{{ $category_name }}">
                                            {{ $category_name }}

                                            @if (count($category->childrenCategories) > 0)
                                                <span class="children-toggle"></span>
                                            @endif
                                        </a>
                                    </span>
                                </div>
                                <ul class="holdermenu-above">
                                    @foreach ($category->childrenCategories->take(6) as $key => $child_category)
                                        <li class="itemmenu-above"> <a
                                                href="{{ route('products.category', $child_category->slug) }}"
                                                class="text-center text-light">
                                                {{ $child_category->getTranslation('name') }}
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>
@endif
