@if (0 < count(get_featured_products()))
    <section class="featured_products">
        <div class="container-fluid defcar">
            <!-- Top Section -->
            <div class="d-flex align-items-baseline justify-content-between">
            </div>
            <!-- Products Section -->
            <div class="px-sm-3 ">
                <div class="crea-carousel featured-products-carousel sm-gutters-16" data-items="4" data-xl-items="4" data-lg-items="4" data-md-items="3"
                    data-sm-items="2" data-xs-items="1" data-arrows='true' data-dots='true' data-autoplay='true'
                    data-autoplaySpeed="2000" data-slidesToScroll="2" data-infinite="true">
                    @foreach (get_featured_products() as $key => $product)
                        <div
                            class="carousel-box position-relative px-0 has-transition hov-animate-outline border-right border-top border-bottom @if ($key == 0) border-left @endif">
                            <div class="px-3">
                                @include(
                                    'frontend.' . get_setting('homepage_select') . '.partials.product_box_4',
                                    ['product' => $product]
                                )
                            </div>
                        </div>
                    @endforeach
                </div>
                <button type="button" class="slick-next slick-arrow" style=""><i
                        class="las la-arrow-right"></i></button>
                <button type="button" class="slick-prev slick-arrow" style=""><i
                        class="las la-arrow-left"></i></button>
            </div>
        </div>
    </section>
    <script type="text/javascript">
        jQuery('.featured-products-carousel').slick({
            slidesToShow: 4,
            slidesToScroll: 2,
            dots: false,
            arrows: true,
            speed: 1100,
            autoplay: true,
            autoplaySpeed: 2000,
            prevArrow: jQuery('.slick-prev'),
            nextArrow: jQuery('.slick-next'),
            responsive: [{
                    breakpoint: 1200,
                    settings: {
                        slidesToShow: 3,
                        slidesToScroll: 1
                    }
                },
                {
                    breakpoint: 850,
                    settings: {
                        slidesToShow: 2,
                        slidesToScroll: 1,
                    }
                },
                {
                    breakpoint: 480,
                    settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1,
                    }
                }
            ]
        });
    </script>
@endif
