@if (0 < count(get_popular_categories()))
    <section class="margin-globe">
        <div class="container">
            <div class="d-flex align-items-baseline justify-content-between btnrow">
                <h3 class="maintitle fw-400">{{ translate('Popular Categories') }}</h3>
            </div>

            <div class="def defcar">
                <div class="crea-carousel popular-categories-carousel sm-gutters-8" data-items="4" data-xl-items="4"
                    data-lg-items="4" data-md-items="2" data-sm-items="1" data-xs-items="1" data-arrows='true'
                    data-dots='true' data-infinite="true">
                    @foreach (get_popular_categories() as $key => $category)
                        <div class="carousel-box px-2 position-relative">
                            @include('frontend.partials.boxes.category_box_1')
                        </div>
                    @endforeach
                </div>

                <button type="button" class="slick-next1 slick-arrow" style=""><i
                        class="las la-arrow-right"></i></button>
                <button type="button" class="slick-prev1 slick-arrow" style=""><i
                        class="las la-arrow-left"></i></button>
            </div>
        </div>
    </section>

    <script type="text/javascript">
        jQuery('.popular-categories-carousel').slick({
            slidesToShow: 6,
            slidesToScroll: 2,
            dots: false,
            arrows: true,
            speed: 900,
            autoplay: true,
            autoplaySpeed: 2500,
            prevArrow: jQuery('.slick-prev1'),
            nextArrow: jQuery('.slick-next1'),
            responsive: [
                {
                    breakpoint: 1440,
                    settings: {
                        slidesToScroll: 1,
                        slidesToShow: 4
                    }
                },
                {
                    breakpoint: 1200,
                    settings: {
                        slidesToScroll: 1,
                        slidesToShow: 3
                    }
                },
                {
                    breakpoint: 850,
                    settings: {
                        slidesToScroll: 1,
                        slidesToShow: 2
                    }
                },
                {
                    breakpoint: 480,
                    settings: {
                        slidesToScroll: 1,
                        slidesToShow: 1
                    }
                }
            ]
        });
    </script>
@endif
