@if (0 < count(get_trendy_products()))
    <section class="margin-globe">
        <div class="container">
            <div class="d-flex align-items-baseline justify-content-between btnrow">
                <h3 class="maintitle fw-400">{{ translate('Trendy Products') }}</h3>

                <a href="{{ route('search') }}" class="viewall">{{ translate('View All') }}</a>
            </div>

            <div class="def defcar">
                <div class="crea-carousel carstyle1 sm-gutters-8" data-items="4" data-xl-items="4" data-lg-items="4"
                    data-md-items="2" data-sm-items="1" data-xs-items="1" data-arrows='true' data-dots='true'
                    data-infinite="true">
                    @foreach (get_trendy_products() as $key => $product)
                        <div class="carousel-box px-2 position-relative  ">
                            @include(
                                'frontend.partials.boxes.product_box_1',
                                ['product' => $product]
                            )
                        </div>
                    @endforeach
                </div>

                <button type="button" class="slick-next1 slick-arrow" style=""><i
                        class="las la-arrow-right"></i></button>
                <button type="button" class="slick-prev1 slick-arrow" style=""><i
                        class="las la-arrow-left"></i></button>
            </div>
        </div>
    </section>

    <script type="text/javascript">
        jQuery('.carstyle1').slick({
            slidesToShow: 5,
            slidesToScroll: 2,
            dots: false,
            arrows: true,
            speed: 900,
            autoplay: true,
            autoplaySpeed: 2500,
            prevArrow: jQuery('.slick-prev1'),
            nextArrow: jQuery('.slick-next1'),

            responsive: [
                {
                    breakpoint: 1480,
                    settings: {
                        slidesToScroll: 1,
                        slidesToShow: 4
                    }
                },
                {
                    breakpoint: 1220,
                    settings: {
                        slidesToScroll: 1,
                        slidesToShow: 3
                    }
                },
                {
                    breakpoint: 850,
                    settings: {
                        slidesToScroll: 1,
                        slidesToShow: 2
                    }
                },
                {
                    breakpoint: 480,
                    settings: {
                        slidesToScroll: 1,
                        slidesToShow: 1
                    }
                }
            ]
        });
    </script>
@endif