<?php
$payload = [
    // Authentication parameters
    'merchantAccount' => env('PAYZONE_MERCHANT_ACCOUNT'),
    'timestamp' => time(),
    'skin' => 'vps-1-vue', // fixed value

    // Customer parameters
    'customerId' => $customer_id, // must be unique for each custumer
    'customerCountry' => 'MA', // fixed value
    'customerLocale' => 'en_US',

    // Charge parameters
    'chargeId' => time(), // Optional, if defined, it must be unique for each redirection to the payment page
    'orderId' => $order_id, // Optional, to identify the cart
    'price' => $price,
    'currency' => 'MAD',
    'description' => $description,

    // Deep linking
    'mode' => 'DEEP_LINK', // fixed value
    'paymentMethod' => 'CREDIT_CARD', // fixed value
    'showPaymentProfiles' => 'false',
    'callbackUrl' => 'https://test-merchant.ma/PayzonePaywall/callback.php',
    'successUrl' => route('order_confirmed'),
    'failureUrl' => route('payzone.failed'),
    'cancelUrl' => route('payzone.cancel'),
];

// Encode the payload
$json_payload = json_encode($payload);
$signature = hash('sha256', env('PAYZONE_PAYWALL_SECRET_KEY') . $json_payload);

$paywall_url = env('PAYZONE_PAYWALL_URL');
?>

<form id="openPaywall" action="<?php echo $paywall_url; ?>" method="POST">
    <input type="hidden" name="payload" value='<?php echo $json_payload; ?>' />
    <input type="hidden" name="signature" value="<?php echo $signature; ?>" />
</form>

<script type="text/javascript">
    document.getElementById("openPaywall").submit();
</script>
