@php
    // Set locale based on the application locale
    if ('fr' == app()->getLocale()) {
        $locale = 'fr_FR';
    } elseif ('ma' == app()->getLocale()) {
        $locale = 'ar_MA';
    } else {
        $locale = 'en_US'; // Use 'en_US' instead of 'en_EN'
    }

    // Convert Unix timestamp to DateTime object
    $event_start_date = (new DateTime())->setTimestamp($detailedProduct->event_start_date);

    // Create date and time formatters
    $dateFormatter = new IntlDateFormatter($locale, IntlDateFormatter::FULL, IntlDateFormatter::NONE);
    $timeFormatter = new IntlDateFormatter($locale, IntlDateFormatter::NONE, IntlDateFormatter::SHORT);

    // Format the date and time according to the locale
    $date = $dateFormatter->format($event_start_date);
    $hour = $timeFormatter->format($event_start_date);

    $timestamp = $detailedProduct->event_end_date;
    $s_date = new DateTime("@$detailedProduct->event_start_date");
    $_date = new DateTime("@$timestamp");
    $currentDate = new DateTime();
@endphp

@extends('frontend.layouts.app')
@section('meta_title'){{ $detailedProduct->meta_title }}@stop
@section('meta_description'){{ $detailedProduct->meta_description }}@stop
@section('meta_keywords'){{ $detailedProduct->tags }}@stop
@section('meta')
    @php
        $availability = 'out of stock';
        $qty = 0;
        if ($detailedProduct->variant_product) {
            foreach ($detailedProduct->stocks as $key => $stock) {
                $qty += $stock->qty;
            }
        } else {
            $qty = optional($detailedProduct->stocks->first())->qty;
        }
        if ($qty > 0) {
            $availability = 'in stock';
        }
    @endphp
    <!-- Schema.org markup for Google+ -->
    <meta itemprop="name" content="{{ $detailedProduct->meta_title }}">
    <meta itemprop="description" content="{{ $detailedProduct->meta_description }}">
    <meta itemprop="image" content="{{ uploaded_asset($detailedProduct->meta_img) }}">
    <!-- Twitter Card data -->
    <meta name="twitter:card" content="product">
    <meta name="twitter:site" content="@publisher_handle">
    <meta name="twitter:title" content="{{ $detailedProduct->meta_title }}">
    <meta name="twitter:description" content="{{ $detailedProduct->meta_description }}">
    <meta name="twitter:creator" content="@author_handle">
<meta name="twitter:image" content="{{ uploaded_asset($detailedProduct->meta_img) }}">
<meta name="twitter:data1" content="{{ single_price($detailedProduct->unit_price) }}">
<meta name="twitter:label1" content="Price">
<!-- Open Graph data -->
<meta property="og:title" content="{{ $detailedProduct->meta_title }}" />
<meta property="og:type" content="og:product" />
<meta property="og:url" content="{{ route('product', $detailedProduct->slug) }}" />
<meta property="og:image" content="{{ uploaded_asset($detailedProduct->meta_img) }}" />
<meta property="og:description" content="{{ $detailedProduct->meta_description }}" />
<meta property="og:site_name" content="{{ get_setting('meta_title') }}" />
<meta property="og:price:amount" content="{{ single_price($detailedProduct->unit_price) }}" />
<meta property="product:brand"
    content="{{ $detailedProduct->brand ? $detailedProduct->brand->name : env('APP_NAME') }}">
<meta property="product:availability" content="{{ $availability }}">
<meta property="product:condition" content="new">
<meta property="product:price:amount" content="{{ number_format($detailedProduct->unit_price, 2) }}">
<meta property="product:retailer_item_id" content="{{ $detailedProduct->slug }}">
<meta property="product:price:currency" content="{{ get_system_default_currency()->code }}" />
<meta property="fb:app_id" content="{{ env('FACEBOOK_PIXEL_ID') }}">
@endsection
@section('content')

@php
$product_categories = $detailedProduct->categories;
@endphp

<div class="container">
    <div class="row">
        <div class="col-md-12">
            <ul
                class="product-breadcrumb breadcrumb justify-content-center justify-content-lg-start bg-transparent p-0">
                <li class="breadcrumb-item has-transition opacity-60 hov-opacity-100">
                    <a class="text-reset" href="{{ route('home') }}">{{ translate('Home') }}</a>
                </li>
                @foreach ($product_categories as $p_category)
                <li class="text-dark fw-600 breadcrumb-item">
                    <a href="{{ route('products.category', $p_category->slug) }}">
                        {{ $p_category->getTranslation('name') }}
                    </a>
                </li>
                @endforeach
            </ul>
        </div>
    </div>
</div>

<div class="container">
    <div class="single-product-info bg-white">
        <div class="row">
            <div class="col-lg-6">
                @include('frontend.product.partials.gallery')
            </div>
            <div class="col-lg-6">
                <form id="option-choice-form">
                    @csrf
                    {{-- Product Name --}}
                    <h1 class="single-product-name">{{ $detailedProduct->getTranslation('name') }}</h1>

                    {{-- Product Rating --}}
                    @include('frontend.product.partials.rating', ['detailedProduct' => $detailedProduct])

                    {{-- Sold in 24h --}}
                    <div class="single-product-sold-24h">
                        <img src="{{ static_asset('assets/img/fire.png') }}" alt="">
                        <span>{{ rand(5, 20) }} {{ translate(' sold in the last 24 hours') }}</span>
                    </div>

                    {{-- Product Price --}}

                    <div class="single-product-price">
                        @if (null !== $detailedProduct->choice_options && count(json_decode($detailedProduct->choice_options)) > 0)
                        <span>{{ translate('Starting from') }}</span>
                        @endif
                        {!! home_discounted_base_price($detailedProduct) !!}
                    </div>

                    {{-- Product Discount --}}
                    @if ('' != product_discount_value($detailedProduct))
                    <div class="single-product-discount">
                        <img src="{{ static_asset('assets/img/discount-icon.png') }}" alt="">
                        <span>
                            {{ translate('Discount of') }}
                        </span>
                        <span>
                            {!! product_discount_value($detailedProduct) !!}
                        </span>
                    </div>
                    @endif

                    <ul>
                        <li>{{ $date }}</li>
                        <li>{{ optional($detailedProduct->city)->getTranslation('name') }}</li>
                        <li>{{ translate('Door opening at ') }} {{ $hour }}</li>
                    </ul>

                    <div class="row">
                        <div class="col-12">
                            <div class="single-product-watching-people">
                                <img src="{{ static_asset('assets/img/eye.png') }}" alt="">
                                {{ rand(5, 35) }}
                                <span>{{ translate(' people are watching this right now') }}</span>
                            </div>
                        </div>
                    </div>

                    {{-- Product Countdown --}}
                    @if ('' != $detailedProduct->event_start_date && $s_date > $currentDate && 0 < $detailedProduct->stocks->first()->qty)
                        <div class="single-product-countdown">
                            <div class="row">
                                <div class="col-md-6">
                                    <span class="countdown-text">
                                        <img src="{{ static_asset('assets/img/countdown-icon.png') }}" alt="">
                                        {{ translate('Hurry up! The sale ends in :') }}
                                    </span>

                                </div>

                                <div class="col-md-6">
                                    <div class="crea-count-down-box"
                                        data-date="{{ date('Y/m/d H:i:s', $detailedProduct->event_start_date) }}">
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif

                        {{-- Product Available Stock --}}
                        <div class="single-product-available-stock">
                            <div class="row">
                                @if (('' != $detailedProduct->event_start_date && $_date > $currentDate) || 0 < $detailedProduct->stocks->first()->qty)
                                    <div class="col-12">
                                        <span>{{ translate('Hurry up! Only ') }}</span>
                                        {{-- <span>{{ $detailedProduct->stocks->first()->qty -
                                            $detailedProduct->orderDetails->sum('quantity') }} {{ translate(' Tickets')
                                            }}</span> --}}
                                        <span>{{ $detailedProduct->stocks->first()->qty }}
                                        
                                         @if ('event' == session('type'))
                                         {{ translate(' Tickets') }}
                                            @elseif ('deal' == session('type')) 
                                            {{ translate(' Deals') }}
                                            @endif
                                         </span>
                                        <span>{{ translate(' en stock !') }}</span>
                                    </div>
                                    <div class="single-product-sales-bar">
                                        <span style="width: 100%;"></span>
                                    </div>
                                    @else
                                    <div class="col-12">
                                        <span>{{ translate('No more reservations are available now') }}</span>
                                    </div>
                                    @endif
                            </div>
                        </div>

                        @if (null !== $detailedProduct->choice_options && count(json_decode($detailedProduct->choice_options)) > 0)
                        @foreach (json_decode($detailedProduct->choice_options) as $key => $choice)
                        <select name="attribute_id_{{ $choice->attribute_id }}" class="pricebox">
                            @foreach ($choice->values as $_key => $value)
                            <option value="{{ $value }}">
                                <div class="d-flex justify-content-between">
                                    <span>{{ $value }} -
                                        {!! format_price($detailedProduct->stocks->where('variant', $value)->first()->price) !!}
                                    </span>
                                </div>
                            </option>
                            @endforeach
                        </select>
                        @endforeach
                        @endif

                        {{-- Quantity + Add to cart --}}
                        @include('frontend.product.partials.qty_addtocart')

                        {{-- Product Whishlist & Share Links --}}
                        <div class="single-product-whishlist-shares">
                            <div class="row">
                                <div class="col-md-5">
                                    <div class="add-to-whishlist">
                                        <img src="{{ static_asset('assets/img/fav.png') }}">

                                        <a href="javascript:void(0)" class="hov-svg-white"
                                            onclick="addToWishList({{ $detailedProduct->id }})" data-toggle="tooltip"
                                            data-title="{{ translate('Add to wishlist') }}" data-placement="left">
                                            {{ translate('Add to wishlist') }}
                                        </a>
                                    </div>
                                </div>

                                <div class="col-md-7">
                                    <div class="share-links">
                                        <span>
                                            <img src="{{ static_asset('assets/img/share.png') }}">
                                            @if ('event' == session('type'))
                                            {{ translate('Share this ticket') }}
                                            @elseif ('deal' == session('type'))                                            
                                            {{ translate('Share this deal') }}
                                            @endif
                                        </span>
                                        <ul>
                                            <li>
                                                <a href="https://www.facebook.com/sharer/sharer.php?u={{ route('product', $detailedProduct->slug) }}"
                                                    target="_blank">
                                                    <img src="{{ static_asset('assets/img/facebook-icon.png') }}">
                                                </a>
                                            </li>
                                            <li>
                                                <a href="https://twitter.com/intent/tweet?url={{ route('product', $detailedProduct->slug) }}"
                                                    target="_blank">
                                                    <img src="{{ static_asset('assets/img/x-icon.png') }}">
                                                </a>
                                            </li>
                                            <li>
                                                <a href="https://www.instagram.com/?url={{ route('product', $detailedProduct->slug) }}"
                                                    target="_blank">
                                                    <img src="{{ static_asset('assets/img/instagram-icon.png') }}">
                                                </a>
                                            </li>
                                            <li>
                                                <a href="https://www.tiktok.com/share?url={{ route('product', $detailedProduct->slug) }}"
                                                    target="_blank">
                                                    <img src="{{ static_asset('assets/img/tiktok-icon.png') }}">
                                                </a>
                                            </li>
                                            <li>
                                                <a href="https://api.whatsapp.com/send?text={{ route('product', $detailedProduct->slug) }}"
                                                    target="_blank">
                                                    <img src="{{ static_asset('assets/img/whatsapp-icon.png') }}">
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- Product Specifications --}}
                        @if ($detailedProduct->brand)
                            <div class="single-product-specifications">
                                <div class="row">
                                    <div class="col-12">
                                        <table class="table">
                                            <tr>
                                                <th>{{ translate('Organisator') }}</th>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <img src="{{ uploaded_asset(optional($detailedProduct->brand)->logo) }}" alt="{{ optional($detailedProduct->brand)->name }}" class="h-50px">
                                                </td>
                                                <td>{{ optional($detailedProduct->brand)->name }}</td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        @endif
                </form>
            </div>
        </div>
    </div>
</div>

<div class="container mt-5">
    @include('frontend.partials.blocks.general_info')
</div>

<div class="container mt-5">
    <div class="single-product-desc-reviews bg-white">
        <div class="d-flex justify-content-center">
            <div class="product-desc-btn active" data-target="#product-description">{{ translate('Description') }}</div>
            <div class="product-reviews-btn" data-target="#product-reviews">{{ translate('Reviews') }}</div>
        </div>
        <div id="product-description">
            @include('frontend.product.partials.description')
        </div>

        <div id="product-reviews" style="display: none;">
            @include('frontend.product.partials.reviews')
        </div>
    </div>
</div>

{{-- Recommendations --}}
@if (0 < count(get_product_recommendations($detailedProduct->category_id)))
<div class="container mt-5">
    <div class="recommendations">
        @include('frontend.product.partials.recommendations', [
            'category_id' => $detailedProduct->category_id,
            'category_slug' => $detailedProduct->main_category->slug,
        ])
    </div>
</div>
@endif

    {{-- Recently Viewed --}}
    @if (0 < count(get_user_recently_viewed())) <div class="container mt-5">
        <div class="recently-viewed">
            @include('frontend.product.partials.recently_viewed')
        </div>
        </div>
        @endif

        @endsection

        @section('modal')
        <!-- Image Modal -->
        <div class="modal fade" id="image_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-dialog-zoom product-modal" id="modal-size"
                role="document">
                <div class="modal-content position-relative">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="p-4">
                        <div class="size-300px size-lg-450px">
                            <img class="img-fit h-100 lazyload" src="{{ static_asset('assets/img/placeholder.jpg') }}"
                                data-src=""
                                onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Chat Modal -->
        <div class="modal fade" id="chat_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-dialog-zoom product-modal" id="modal-size"
                role="document">
                <div class="modal-content position-relative">
                    <div class="modal-header">
                        <h5 class="modal-title fw-600 h5">{{ translate('Any query about this product') }}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form class="" action="{{ route('conversations.store') }}" method="POST"
                        enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="product_id" value="{{ $detailedProduct->id }}">
                        <div class="modal-body gry-bg px-3 pt-3">
                            <div class="form-group">
                                <input type="text" class="form-control mb-3 rounded-0" name="title"
                                    value="{{ $detailedProduct->name }}" placeholder="{{ translate('Product Name') }}"
                                    required>
                            </div>
                            <div class="form-group">
                                <textarea class="form-control rounded-0" rows="8" name="message" required
                                    placeholder="{{ translate('Your Question') }}">{{ route('product', $detailedProduct->slug) }}</textarea>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-outline-primary fw-600 rounded-0"
                                data-dismiss="modal">{{ translate('Cancel') }}</button>
                            <button type="submit" class="btn btn-primary fw-600 rounded-0 w-100px">{{ translate('Send') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- Bid Modal -->
        @if ($detailedProduct->auction_product == 1)
        @php
        $highest_bid = $detailedProduct->bids->max('amount');
        $min_bid_amount = $highest_bid != null ? $highest_bid+1 : $detailedProduct->starting_bid;
        @endphp
        <div class="modal fade" id="bid_for_detail_product" tabindex="-1" role="dialog"
            aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">{{ translate('Bid For Product') }} <small>({{ translate('Min Bid Amount: ') . $min_bid_amount }})</small> </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        </button>
                    </div>
                    <div class="modal-body">
                        <form class="form-horizontal" action="{{ route('auction_product_bids.store') }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="product_id" value="{{ $detailedProduct->id }}">
                            <div class="form-group">
                                <label class="form-label">
                                    {{ translate('Place Bid Price') }}
                                    <span class="text-danger">*</span>
                                </label>
                                <div class="form-group">
                                    <input type="number" step="0.01" class="form-control form-control-sm" name="amount"
                                        min="{{ $min_bid_amount }}" placeholder="{{ translate('Enter Amount') }}"
                                        required>
                                </div>
                            </div>
                            <div class="form-group text-right">
                                <button type="submit" class="btn btn-sm btn-primary transition-3d-hover mr-1">{{ translate('Submit') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        @endif
@endsection

@section('script')
<script type="text/javascript">
    var page = 1; // Initial page number
    var loading = false; // To prevent multiple requests
    var stopLoading = false;
            

    $(document).ready(function () {
        $('.product-desc-btn').on('click', function () {
            $('#product-reviews').hide();
            $('.product-reviews-btn').removeClass('active');

            $('#product-description').show();
            $('.product-desc-btn').addClass('active');
        });

        $('.product-reviews-btn').on('click', function () {
            $('#product-description').hide();
            $('.product-desc-btn').removeClass('active');

            $('#product-reviews').show();
            $('.product-reviews-btn').addClass('active')
        });

        $('#add-review-btn').on('click',function() {
            $(this).hide();
            $('#review-form').show();
        });

        $('#add-review').on('click', function() {
            const product_id = $('[name="product_id"]').val();
            const rating = $('[name="rating"]:checked').val();
            const comment = $('[name="comment"]').val();    

            if (rating == undefined || '' == rating) {
                CREA.plugins.notify('danger', "{{ translate('You should rating the offer!') }}");
                return;
            }

            if ('' == comment) {
                CREA.plugins.notify('danger', "{{ translate('Comment is required!') }}");
                return;
            }

            $.ajax({
                url: '{{ route('reviews.store') }}',
                type: 'POST',
                dataType: 'json',
                data: {
                    _token: CREA.data.csrf,
                    product_id: product_id,
                    rating: rating,
                    comment: comment 
                },
                success: function(response) {
                    console.log(response);
                    if ('success' == response.status) {
                        CREA.plugins.notify(response.status, response.message);
                        return;
                    }
                },  
                error: function(error) {
                    console.error(error);
                }
            })
        });
    });
            
            // Pagination using ajax
    $(window).on('hashchange', function () {
        if (window.history.pushState) {
            window.history.pushState('', '/', window.location.pathname);
        } else {
            window.location.hash = '';
        }
    });
    
    $(document).ready(function () {
        $(document).on('click', '.product-queries-pagination .pagination a', function (e) {
            getPaginateData($(this).attr('href').split('page=')[1], 'query', 'queries-area');
            e.preventDefault();
        });
    });
    
    $(document).ready(function () {
        $(document).on('click', '.product-reviews-pagination .pagination a', function (e) {
            getPaginateData($(this).attr('href').split('page=')[1], 'review', 'reviews-area');
            e.preventDefault();
        });
    });
    
    function getPaginateData(page, type, section) {
        $.ajax({
            url: '?page=' + page,
            dataType: 'json',
            data: { type: type },
        }).done(function (data) {
            $('.' + section).html(data);
            location.hash = page;
        }).fail(function () {
            alert('Something went worng! Data could not be loaded.');
        });
    }
    
    // Pagination end
    function showImage(photo) {
        $('#image_modal img').attr('src', photo);
        $('#image_modal img').attr('data-src', photo);
        $('#image_modal').modal('show');
    }
    
    function bid_modal() {
        @if (isCustomer() || isSeller())
            $('#bid_for_detail_product').modal('show');
        @elseif(isAdmin())
        CREA.plugins.notify('warning', '{{ translate('Sorry, Only customers & Sellers can Bid.') }}');
        @else
        $('#login_modal').modal('show'); @endif
                                                            }
                                                        </script>
@endsection
