<div class="d-flex">
    <div class="row no-gutters mb-0 inputcol">
        <div class="col-sm-12">
            <div class="product-quantity d-flex align-items-center">
                <div class="row no-gutters bg-white align-items-center crea-plus-minus "
                    style="width: 100%;border-radius: 5px">
                    <button class="btn col-auto btn-icon btn-sm btn-light rounded-0" type="button" data-type="minus"
                        data-field="quantity" disabled="">
                        <i class="las la-minus"></i>
                    </button>
                    <input type="number" name="quantity"
                        class="col border-0 text-center flex-grow-1 fs-16 input-number" placeholder="1"
                        value="{{ $detailedProduct->min_qty }}" min="{{ $detailedProduct->min_qty }}" max="10"
                        lang="en" @disabled($_date < $currentDate || 0 == $detailedProduct->stocks->first()->qty)>
                    <button class="btn col-auto btn-icon btn-sm btn-light rounded-0" type="button"
                        @if (!($_date < $currentDate || 0 == $detailedProduct->stocks->first()->qty)) data-type="plus"
                        data-field="quantity" @endif
                        @disabled($_date < $currentDate || 0 == $detailedProduct->stocks->first()->qty)>
                        <i class="las la-plus"></i>
                    </button>
                </div>
                @php
                    $qty = 0;
                    foreach ($detailedProduct->stocks as $key => $stock) {
                        $qty += $stock->qty;
                    }
                @endphp
            </div>
            <div class="row">
                <div class="col-md-12">
                    <span class="text-danger" id="qty-message"></span>
                </div>
            </div>
        </div>
    </div>
    <div class="sevenpercent">
        <input type="hidden" name="id" value="{{ $detailedProduct->id }}">
        @if ($_date < $currentDate || 0 == $detailedProduct->stocks->first()->qty)
            <button type="button" disabled data-stock="{{ $detailedProduct->stocks->first()->qty }}"
                class="btn btn-secondary-base add-to-cart fw-600 min-w-150px rounded-0 text-white">
                @if (0 == $detailedProduct->stocks->first()->qty)
                    {{ translate('Sold out') }}
                @else
                    @if ('event' == $detailedProduct->nature)
                        {{ translate('Event is over') }}
                    @else
                        @if ('deal' == $detailedProduct->nature)
                            {{ translate('End of deal') }}
                        @endif
                    @endif
                @endif
            </button>
        @else
            <button type="button" data-stock="{{ $detailedProduct->stocks->first()->qty }}"
                class="btn btn-secondary-base add-to-cart fw-600 min-w-150px rounded-0 text-white"
                @if (Auth::check() || get_Setting('guest_checkout_activation') == 1) onclick="addToCart()"
                                @else onclick="showLoginModal()" @endif>
                {{ translate('Buy Now') }}
            </button>
        @endif
    </div>
</div>
