<div class="row">
    <div class="col-md-6">
        <div class="py-3 reviews-area">
            @if (count($reviews) <= 0)
                <div class="text-center fs-18 opacity-70">
                    {{ translate('There have been no reviews for this product yet.') }}
                </div>
            @else
                <ul class="list-group list-group-flush">
                    @foreach ($reviews as $key => $review)
                        @if ($review->user != null)
                            <li class="media list-group-item d-flex px-3 px-md-4 border-0">
                                <!-- Review User Image -->
                                <span class="avatar avatar-md mr-3">
                                    <img class="lazyload" src="{{ static_asset('assets/img/placeholder.jpg') }}"
                                        onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';"
                                        @if ($review->user->avatar_original != null) data-src="{{ uploaded_asset($review->user->avatar_original) }}"
                        @else
                            data-src="{{ static_asset('assets/img/placeholder.jpg') }}" @endif>
                                </span>
                                <div class="media-body text-left">
                                    <!-- Review User Name -->
                                    <div class="reviewsmallbox d-flex align-items-center">
                                    <h3 class="fs-15 fw-600 mb-0">{{ $review->user->name }}
                                    </h3>
                                    <!-- Review Date -->
                                    <div class="ml-2 mr-2 opacity-60 mb-0">
                                        {{ date('d-m-Y', strtotime($review->created_at)) }}
                                    </div>
                                    <!-- Review ratting -->
                                    <span class="rating rating-mr-2">
                                        @for ($i = 0; $i < $review->rating; $i++)
                                            <i class="las la-star active"></i>
                                        @endfor
                                        @for ($i = 0; $i < 5 - $review->rating; $i++)
                                            <i class="las la-star"></i>
                                        @endfor
                                    </span>

</div>
                                    <!-- Review Comment -->
                                    <p class="comment-text mt-2 fs-14">
                                        {{ $review->comment }}
                                    </p>
                                    <!-- Review Images -->
                                    <div class="spotlight-group d-flex flex-wrap">
                                        @if ($review->photos != null)
                                            @foreach (explode(',', $review->photos) as $photo)
                                                <a class="spotlight mr-2 mr-md-3 mb-2 mb-md-3 size-60px size-md-90px border overflow-hidden has-transition hov-scale-img hov-border-primary"
                                                    href="{{ uploaded_asset($photo) }}">
                                                    <img class="img-fit h-100 lazyload has-transition"
                                                        src="{{ static_asset('assets/img/placeholder.jpg') }}"
                                                        data-src="{{ uploaded_asset($photo) }}"
                                                        onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';">
                                                </a>
                                            @endforeach
                                        @endif
                                    </div>
                                    <!-- Variation -->
                                    @php
                                        $OrderDetail = get_order_details_by_review($review);
                                    @endphp
                                    @if ($OrderDetail && $OrderDetail->variation)
                                        <small class="text-secondary fs-12">{{ translate('Variation :') }}
                                            {{ $OrderDetail->variation }}</small>
                                    @endif
                                </div>
                            </li>
                        @endif
                    @endforeach
                </ul>

                <div class="crea-pagination product-reviews-pagination py-2 px-4 d-flex justify-content-end">
                    {{ $reviews->links() }}
                </div>
            @endif
        </div>
    </div>
    <div class="col-md-6">
        @php
            $total = 0;
            $total +=
                $detailedProduct->reviews->count() > 0
                    ? $detailedProduct->reviews->count()
                    : $detailedProduct->default_sales;
        @endphp

        <div class="row pt-4">
            <div class="col-md-6 dblocklap">
                <div class="d-flex align-items-center">
                    <h4>
                    {{-- {{ $detailedProduct->rating > 0 ? $detailedProduct->rating : $detailedProduct->default_reviews_stars }} --}}
                    {{  $detailedProduct->default_reviews_stars }}
                    </h4>
                    <div class="d-flex flex-column">
                        <div
                            class="mt-sm-3 w-100 w-sm-auto d-flex flex-wrap justify-content-end justify-content-md-start reviews-stars">
                            <span class="rating rating-mr-2">
                                {{ renderStarRating($detailedProduct->rating > 0 ? $detailedProduct->rating : $detailedProduct->default_reviews_stars) }}
                            </span>
                        </div>
                        <span class="tooltitle">{{ translate('Average based on ') }} {{ $total }}
                            {{ translate('review(s)') }}</span>
                    </div>
                </div>
            </div>
            <div class="col-md-6 dblocklap">
                <ul class="reviewsprd2">
                    <li>
                        <div class="reviewstarttool">
                            {{ renderStarRating(5) }}
                        </div>
                        <div class="max140">
                            @php
                                if (
                                    $detailedProduct->reviews->count() == 0 &&
                                    $detailedProduct->five_star_reviews == 0 &&
                                    $detailedProduct->default_reviews_stars == 5
                                ) {
                                    $detailedProduct->five_star_reviews = $detailedProduct->default_sales;
                                }
                            @endphp
                            <span
                                style="width:   {{ ($total > 0 ? $detailedProduct->five_star_reviews / $total : 0) * 100 }}%"></span>
                        </div>
                        <div>
                            {{ $total > 0 ? round(number_format(($detailedProduct->five_star_reviews / $total) * 100, 2)) : 0 }}%
                        </div>
                    </li>
                    <li>
                        <div class="reviewstarttool">
                            {{ renderStarRating(4) }}
                        </div>
                        <div class="max140">
                            @php
                                if (
                                    $detailedProduct->reviews->count() == 0 &&
                                    $detailedProduct->four_star_reviews == 0 &&
                                    $detailedProduct->default_reviews_stars == 4
                                ) {
                                    $detailedProduct->four_star_reviews = $detailedProduct->default_sales;
                                }
                            @endphp
                            <span
                                style="width: {{ ($total > 0 ? $detailedProduct->four_star_reviews / $total : 0) * 100 }}%"></span>
                        </div>
                        <div>
                            {{ $total > 0 ? round(number_format(($detailedProduct->four_star_reviews / $total) * 100, 2)) : 0 }}%
                        </div>
                    </li>
                    <li>
                        <div class="reviewstarttool">
                            {{ renderStarRating(3) }}
                        </div>
                        <div class="max140">
                            @php
                                if (
                                    $detailedProduct->reviews->count() == 0 &&
                                    $detailedProduct->three_star_reviews == 0 &&
                                    $detailedProduct->default_reviews_stars == 3
                                ) {
                                    $detailedProduct->three_star_reviews = $detailedProduct->default_sales;
                                }
                            @endphp
                            <span
                                style="width: {{ ($total > 0 ? $detailedProduct->three_star_reviews / $total : 0) * 100 }}%"></span>
                        </div>
                        <div>
                            {{ $total > 0 ? round(number_format(($detailedProduct->three_star_reviews / $total) * 100, 2)) : 0 }}%
                        </div>
                    </li>
                    <li>
                        <div class="reviewstarttool">
                            {{ renderStarRating(2) }}
                        </div>
                        <div class="max140">
                            @php
                                if (
                                    $detailedProduct->reviews->count() == 0 &&
                                    $detailedProduct->two_star_reviews == 0 &&
                                    $detailedProduct->default_reviews_stars == 2
                                ) {
                                    $detailedProduct->two_star_reviews = $detailedProduct->default_sales;
                                }
                            @endphp
                            <span
                                style="width:   {{ ($total > 0 ? $detailedProduct->two_star_reviews / $total : 0) * 100 }}%"></span>
                        </div>

                        <div>
                            {{ $total > 0 ? round(number_format(($detailedProduct->two_star_reviews / $total) * 100, 2)) : 0 }}%
                        </div>
                    </li>
                    <li>
                        <div class="reviewstarttool">
                            {{ renderStarRating(1) }}
                        </div>
                        <div class="max140">
                            @php
                                if (
                                    $detailedProduct->reviews->count() == 0 &&
                                    $detailedProduct->one_star_reviews == 0 &&
                                    $detailedProduct->default_reviews_stars == 1
                                ) {
                                    $detailedProduct->one_star_reviews = $detailedProduct->default_sales;
                                }
                            @endphp
                            <span
                                style="width:   {{ ($total > 0 ? $detailedProduct->one_star_reviews / $total : 0) * 100 }}%"></span>
                        </div>

                        <div>
                            {{ $total > 0 ? round(number_format(($detailedProduct->one_star_reviews / $total) * 100, 2)) : 0 }}%
                        </div>
                    </li>
                </ul>
            </div>
        </div>

        {{-- @if (auth()->check())
            @if (1 == $review_status)
                @if (null != $review) --}}
                    <button id="add-review-btn" class="btn btn-warning">{{ translate('Add a review') }}</button>

                    <form id="review-form" action="{{ route('reviews.store') }}" method="POST" style="display: none;">
                        @csrf
                        <input type="hidden" name="product_id" value="{{ $detailedProduct->id }}">
                        <div class="ratingtit form-group">
                            <label class="">{{ translate('Product') }}</label>
                            <p>{{ $detailedProduct->getTranslation('name') }}</p>
                        </div>
                        <!-- Rating -->
                        <div class="form-group">
                            <label class="">{{ translate('Rating') }}</label>
                            <br>

                            <div class="rating rating-input">
                                <label>
                                    <input type="radio" name="rating" value="1" required>
                                    <i class="las la-star"></i>
                                </label>
                                <label>
                                    <input type="radio" name="rating" value="2">
                                    <i class="las la-star"></i>
                                </label>
                                <label>
                                    <input type="radio" name="rating" value="3">
                                    <i class="las la-star"></i>
                                </label>
                                <label>
                                    <input type="radio" name="rating" value="4">
                                    <i class="las la-star"></i>
                                </label>
                                <label>
                                    <input type="radio" name="rating" value="5">
                                    <i class="las la-star"></i>
                                </label>
                            </div>
                        </div>
                        <!-- Comment -->
                        <div class="form-group">
                            <label class="">{{ translate('Comment') }}</label>
                            <textarea class="form-control rounded-0" rows="4" name="comment" placeholder="{{ translate('Your review') }}"
                                required></textarea>
                        </div>

                        <button id="add-review" type="button"
                            class="btn btn-outline btn-sm btn-primary rounded-0 submitbtn">{{ translate('Submit Review') }}</button>
                    </form>
                {{-- @else
                    <div class="revmsg">
                        <img src="{{ static_asset('assets/img/log-in-ico.webp') }}">

                        <h3>{{ translate('Thank you for your review!') }}</h3>
                        <p>{{ translate('You have already shared your opinion on this product. We appreciate your feedback!') }}
                        </p>
                    </div>
                @endif
            @else
                <div class="revmsg">
                    <img src="{{ static_asset('assets/img/enregistre-ico.webp') }}">

                    <h3>{{ translate('Reviews are limited to verified buyers!') }}</h3>
                    <p>{{ translate('We value genuine feedback to help our customers make the best choices.') }}<br>{{ translate('Only those who have purchased this product can leave a review.') }}
                    </p>
                </div>
            @endif
        @else
            <div class="revmsg">
                <img src="{{ static_asset('assets/img/log-in-ico.webp') }}">

                <h3>{{ translate('Log in to share your opinion!') }}</h3>
                <p>{{ translate('We’d love to hear your feedback, but you need to log into your account before posting a review for this product.') }}
                </p>
            </div>
        @endif --}}
    </div>
</div>
