@extends('frontend.layouts.app')
@section('meta_title'){{ $detailedProduct->meta_title }}@stop
@section('meta_description'){{ $detailedProduct->meta_description }}@stop
@section('meta_keywords'){{ $detailedProduct->tags }}@stop
@section('meta')
    @php
        $availability = 'out of stock';
        $qty = 0;
        if ($detailedProduct->variant_product) {
            foreach ($detailedProduct->stocks as $key => $stock) {
                $qty += $stock->qty;
            }
        } else {
            $qty = optional($detailedProduct->stocks->first())->qty;
        }
        if ($qty > 0) {
            $availability = 'in stock';
        }
    @endphp
    <!-- Schema.org markup for Google+ -->
    <meta itemprop="name" content="{{ $detailedProduct->meta_title }}">
    <meta itemprop="description" content="{{ $detailedProduct->meta_description }}">
    <meta itemprop="image" content="{{ uploaded_asset($detailedProduct->meta_img) }}">
    <!-- Twitter Card data -->
    <meta name="twitter:card" content="product">
    <meta name="twitter:site" content="@publisher_handle">
    <meta name="twitter:title" content="{{ $detailedProduct->meta_title }}">
    <meta name="twitter:description" content="{{ $detailedProduct->meta_description }}">
    <meta name="twitter:creator"
        content="@author_handle">
    <meta name="twitter:image" content="{{ uploaded_asset($detailedProduct->meta_img) }}">
    <meta name="twitter:data1" content="{{ single_price($detailedProduct->unit_price) }}">
    <meta name="twitter:label1" content="Price">
    <!-- Open Graph data -->
    <meta property="og:title" content="{{ $detailedProduct->meta_title }}" />
    <meta property="og:type" content="og:product" />
    <meta property="og:url" content="{{ route('product', $detailedProduct->slug) }}" />
    <meta property="og:image" content="{{ uploaded_asset($detailedProduct->meta_img) }}" />
    <meta property="og:description" content="{{ $detailedProduct->meta_description }}" />
    <meta property="og:site_name" content="{{ get_setting('meta_title') }}" />
    <meta property="og:price:amount" content="{{ single_price($detailedProduct->unit_price) }}" />
    <meta property="product:brand" content="{{ $detailedProduct->brand ? $detailedProduct->brand->name : env('APP_NAME') }}">
    <meta property="product:availability" content="{{ $availability }}">
    <meta property="product:condition" content="new">
    <meta property="product:price:amount" content="{{ number_format($detailedProduct->unit_price, 2) }}">
    <meta property="product:retailer_item_id" content="{{ $detailedProduct->slug }}">
    <meta property="product:price:currency"
        content="{{ get_system_default_currency()->code }}" />
    <meta property="fb:app_id" content="{{ env('FACEBOOK_PIXEL_ID') }}">
@endsection
@section('content')
    {{-- Featured Categories --}}
    @if (count($featured_categories) > 0)
        <section class="categories-sec">
            <div class="container">
                <!-- Categories -->
                <div>
                    <div class="d-flex">
                        <div class=" px-0 cat-item first-item-cat">
                            <div class=" text-center ">
                                <div class="px-0">
                                    <span class="text-dark mb-0  text-truncate-2">
                                        <a href="{{ url('/search?sort_by=newest') }}" title="New in">
                                            {{ translate('NEW IN') }}
                                        </a>
                                    </span>
                                </div>
                            </div>
                        </div>
                        @foreach ($featured_categories->take(7) as $key => $category)
                            @php
                                $category_name = $category->getTranslation('name');
                            @endphp
                            <div class=" px-0 cat-item ">
                                <div class=" itemhold text-center ">
                                    <div>
                                        <a href="{{ route('products.category', $category->slug) }}"
                                            title="{{ $category_name }}"> <img
                                                src="{{ isset($category->bannerImage->file_name) ? my_asset($category->bannerImage->file_name) : static_asset('assets/img/placeholder.jpg') }}"
                                                class="lazyload h-auto mx-auto has-transition"
                                                alt="{{ $category->getTranslation('name') }}"
                                                onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';"></a>
                                    </div>
                                    <div class="px-0">
                                        <span class="text-dark mb-0 text-truncate-2">
                                            <a href="{{ route('products.category', $category->slug) }}"
                                                title="{{ $category_name }}">
                                                {{ $category_name }}

                                                @if (count($category->childrenCategories) > 0)
                                                    <span class="children-toggle"></span>
                                                @endif
                                            </a>
                                        </span>
                                    </div>
                                    <ul class="holdermenu-above">
                                        @foreach ($category->childrenCategories->take(6) as $key => $child_category)
                                            <li class="itemmenu-above"> <a
                                                    href="{{ route('products.category', $child_category->slug) }}"
                                                    class="text-center text-light">
                                                    {{ $child_category->getTranslation('name') }}
                                                </a>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </section>
    @endif

    @php
        $top_banner_image = get_setting('single_product_top_banner_image');
        $top_banner_link = get_setting('single_product_top_banner_link');
    @endphp

    @if (null != $top_banner_image)
        <div class="container">
            <div class="col-md-12 text-center product-top-banner">
                <a href="{{ $top_banner_link }}">
                    <img src="{{ uploaded_asset($top_banner_image) }}">
                </a>
            </div>
        </div>
    @endif

    @php
        $product_categories = $detailedProduct->categories;
    @endphp

    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <ul class="product-breadcrumb breadcrumb justify-content-center justify-content-lg-start bg-transparent p-0">
                    <li class="breadcrumb-item has-transition opacity-60 hov-opacity-100">
                        <a class="text-reset" href="{{ route('home') }}">{{ translate('Home') }}</a>
                    </li>
                    @foreach ($product_categories as $p_category)
                        <li class="text-dark fw-600 breadcrumb-item">
                            <a href="{{ route('products.category', $p_category->slug) }}">
                                {{ $p_category->getTranslation('name') }}
                            </a>
                        </li>
                    @endforeach
                </ul>
            </div>
        </div>
       <span class="prdtitle-holder"><h1 class="prd-maintitle">{{ $detailedProduct->getTranslation('name') }}</h1></span>
    </div> 

    @include('frontend.product_details.review_section')

    <section class="mb-4 pt-0">
        <div class="container boxsinglepr">
            <div class="  py-4">
                <div class="row">
                    <!-- Product Image Gallery -->
                    <div class="col-xl-8 col-lg-8 mb-0 galleryimg-box">
                        @include('frontend.product_details.image_gallery')
                        @include('frontend.product_details.description')
                    </div>
                    <!-- Product Details -->
                    <div class="col-xl-4 col-lg-4 rightboxprd">
                        @include('frontend.product_details.details')
                    </div>
                </div>
            </div>
        </div>
    </section>

    {{-- Releted Products --}}
    <section class="related-sectionsinlge">
        <div class="container">
            <div class="row">
                {{-- Logo --}}
                <div class="col-md-12 text-center">
                    <img style="max-width: 205px" src="{{ url('public/assets/img/logo-deelgo.webp') }}" alt="{{ translate('Logo Deelgo') }}">
                </div>
                <div class="col-md-12 text-center">
                    @if ('event' == $detailedProduct->nature)
                        <h2 class="titleotherdeal">{{ translate('Other events') }}</h2>
                    @elseif ('deal' == $detailedProduct->nature)
                        <h2 class="titleotherdeal">{{ translate('Other deals') }}</h2>
                    @endif
                </div>
            </div>
            <div class="">
                @php
                    $relatedProducts = get_related_products($detailedProduct->category_id);
                @endphp

                @if (0 < count($relatedProducts))
                    <div id="content" class="row">
                        
                    </div>
                @endif
            </div>
        </div>
    </section>
    @if (count($all_categories) > 0)
        <div class="container">
            <div class="row">
                <div id="loading" class="col-md-12 text-center" style="display: none;">
                    @if ('event' == $detailedProduct->nature)
                        <h2 class="moreevents">{{ translate('More events') }}</h2>
                    @elseif ('deal' == $detailedProduct->nature)
                        <h2 class="moreevents">{{ translate('More deals') }}</h2>
                    @endif
                </div>
            </div>
        </div>


        <section class="categories-sec-bot">
            <div class="container">
                <!-- Categories -->
                <div class="bg-red ">
                    <div class="featured-cats-bot">
                        @foreach ($all_categories->take(99) as $key => $category)
                            @php
                                $category_name = $category->getTranslation('name');
                            @endphp
                            <div class="cat-item-bot">
                                <div class=" text-center ">
                                    <div class="px-0">
                                        <span class="text-dark mb-0 text-truncate-2">
                                            <a href="{{ route('products.category', $category->slug) }}"
                                                title="{{ $category_name }}" class="text-center ">
                                                {{ $category_name }}
                                            </a>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </section>
    @endif
@endsection

@section('modal')
    <!-- Image Modal -->
    <div class="modal fade" id="image_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-zoom product-modal" id="modal-size" role="document">
            <div class="modal-content position-relative">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="p-4">
                    <div class="size-300px size-lg-450px">
                        <img class="img-fit h-100 lazyload"
                            src="{{ static_asset('assets/img/placeholder.jpg') }}"
                            data-src=""
                            onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Chat Modal -->
    <div class="modal fade" id="chat_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-zoom product-modal" id="modal-size" role="document">
            <div class="modal-content position-relative">
                <div class="modal-header">
                    <h5 class="modal-title fw-600 h5">{{ translate('Any query about this product') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form class="" action="{{ route('conversations.store') }}" method="POST"
                    enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="product_id" value="{{ $detailedProduct->id }}">
                    <div class="modal-body gry-bg px-3 pt-3">
                        <div class="form-group">
                            <input type="text" class="form-control mb-3 rounded-0" name="title"
                                value="{{ $detailedProduct->name }}" placeholder="{{ translate('Product Name') }}"
                                required>
                        </div>
                        <div class="form-group">
                            <textarea class="form-control rounded-0" rows="8" name="message" required
                                placeholder="{{ translate('Your Question') }}">{{ route('product', $detailedProduct->slug) }}</textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-primary fw-600 rounded-0"
                            data-dismiss="modal">{{ translate('Cancel') }}</button>
                        <button type="submit" class="btn btn-primary fw-600 rounded-0 w-100px">{{ translate('Send') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Bid Modal -->
    @if ($detailedProduct->auction_product == 1)
        @php 
            $highest_bid = $detailedProduct->bids->max('amount');
            $min_bid_amount = $highest_bid != null ? $highest_bid+1 : $detailedProduct->starting_bid; 
        @endphp
        <div class="modal fade" id="bid_for_detail_product" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">{{ translate('Bid For Product') }} <small>({{ translate('Min Bid Amount: ') . $min_bid_amount }})</small> </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        </button>
                    </div>
                    <div class="modal-body">
                        <form class="form-horizontal" action="{{ route('auction_product_bids.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="product_id" value="{{ $detailedProduct->id }}">
                            <div class="form-group">
                                <label class="form-label">
                                    {{ translate('Place Bid Price') }}
                                    <span class="text-danger">*</span>
                                </label>
                                <div class="form-group">
                                    <input type="number" step="0.01" class="form-control form-control-sm" name="amount" min="{{ $min_bid_amount }}" placeholder="{{ translate('Enter Amount') }}" required>
                                </div>
                            </div>
                            <div class="form-group text-right">
                                <button type="submit" class="btn btn-sm btn-primary transition-3d-hover mr-1">{{ translate('Submit') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif
    
    <!-- Product Review Modal -->
    <div class="modal fade" id="product-review-modal">
        <div class="modal-dialog">
            <div class="modal-content" id="product-review-modal-content">
            </div>
        </div>
    </div>
    <!-- Size chart show Modal -->
    @include('modals.size_chart_show_modal')
@endsection

@section('script')
    <script type="text/javascript">
        var page = 1; // Initial page number
        var loading = false; // To prevent multiple requests
        var stopLoading = false;

        function loadMoreContent() {
            if (loading || stopLoading) return;

            loading = true;
            $('#loading').show();
  
            $.ajax({
                url: '{{ route('product.load_more') }}',
                method: 'GET',
                data: {
                    page: page,
                    category_id: @isset($detailedProduct->category_id)
                        {{ $detailedProduct->category_id }}
                    @else
                        null
                    @endif
                },
                success: function(response) {
                    if (0 < response.products.length) {
                        $('#content').append(response.products); // Append new content
                        CREA.plugins.countDownBox();
                        page++;
                    } else {
                        stopLoading = true;
                    }
                    loading = false;
                    $('#loading').hide();
                },
                error: function() {
                    // loading = false;
                    // $('#loading').hide();
                }
            });
        }

        $(window).scroll(function() {
            if ($(window).scrollTop() + $(window).height() >= $(document).height() - 650) {
                console.log('Debug Load more');

                loadMoreContent();
            }
        });

        $(document).ready(function() {
            getVariantPrice();

            loadMoreContent();
        });
        function CopyToClipboard(e) {
            var url = $(e).data('url');
            var $temp = $("<input>");
            $("body").append($temp);
            $temp.val(url).select();
            try {
                document.execCommand("copy");
                CREA.plugins.notify('success', '{{ translate('Link copied to clipboard') }}');
            } catch (err) {
                CREA.plugins.notify('danger', '{{ translate('Oops, unable to copy') }}');
            }
            $temp.remove();
            // if (document.selection) {
            //     var range = document.body.createTextRange();
            //     range.moveToElementText(document.getElementById(containerid));
            //     range.select().createTextRange();
            //     document.execCommand("Copy");
            // } else if (window.getSelection) {
            //     var range = document.createRange();
            //     document.getElementById(containerid).style.display = "block";
            //     range.selectNode(document.getElementById(containerid));
            //     window.getSelection().addRange(range);
            //     document.execCommand("Copy");
            //     document.getElementById(containerid).style.display = "none";
            // }
            // CREA.plugins.notify('success', 'Copied');
        }
        function show_chat_modal() {
            @if (Auth::check())
                $('#chat_modal').modal('show');
            @else
                $('#login_modal').modal('show');
            @endif
        }
        // Pagination using ajax
        $(window).on('hashchange', function() {
            if(window.history.pushState) {
                window.history.pushState('', '/', window.location.pathname);
            } else {
                window.location.hash = '';
            }
        });
        $(document).ready(function() {
            $(document).on('click', '.product-queries-pagination .pagination a', function(e) {
                getPaginateData($(this).attr('href').split('page=')[1], 'query', 'queries-area');
                e.preventDefault();
            });
        });
        $(document).ready(function() {
            $(document).on('click', '.product-reviews-pagination .pagination a', function(e) {
                getPaginateData($(this).attr('href').split('page=')[1], 'review', 'reviews-area');
                e.preventDefault();
            });
        });
        function getPaginateData(page, type, section) {
            $.ajax({
                url: '?page=' + page,
                dataType: 'json',
                data: {type: type},
            }).done(function(data) {
                $('.'+section).html(data);
                location.hash = page;
            }).fail(function() {
                alert('Something went worng! Data could not be loaded.');
            });
        }
        // Pagination end
        function showImage(photo) {
            $('#image_modal img').attr('src', photo);
            $('#image_modal img').attr('data-src', photo);
            $('#image_modal').modal('show');
        }
        function bid_modal(){
            @if (isCustomer() || isSeller())
                $('#bid_for_detail_product').modal('show');
          	@elseif (isAdmin())
                CREA.plugins.notify('warning', '{{ translate('Sorry, Only customers & Sellers can Bid.') }}');
            @else
                $('#login_modal').modal('show');
            @endif
        }
        function product_review(product_id) {
            @if (isCustomer())
                // @if ($review_status == 1)
                //     $.post('{{ route('product_review_modal') }}', {
                //         _token: '{{ @csrf_token() }}',
                //         product_id: product_id
                //     }, function(data) {
                //         $('#product-review-modal-content').html(data);
                //         $('#product-review-modal').modal('show', {
                //             backdrop: 'static'
                //         });
                //         CREA.extra.inputRating();
                //     });
                // @else
                //     CREA.plugins.notify('warning', '{{ translate('Sorry, You need to buy this product to give review.') }}');
                // @endif

                $.post('{{ route('product_review_modal') }}', {
                    _token: '{{ @csrf_token() }}',
                    product_id: product_id
                }, function(data) {
                    $('#product-review-modal-content').html(data);
                    $('#product-review-modal').modal('show', {
                        backdrop: 'static'
                    });
                    CREA.extra.inputRating();
                });
            @elseif (Auth::check() && !isCustomer())
                CREA.plugins.notify('warning', '{{ translate('Sorry, Only customers can give review.') }}');
            @else
                CREA.plugins.notify('warning', '{{ translate('Sorry, Only customers can give review.') }}'); @endif
        }
        function showSizeChartDetail(id, name){
            $('#size-chart-show-modal .modal-title').html('');
            $('#size-chart-show-modal .modal-body').html('');
            if (id == 0) {
                CREA.plugins.notify('warning', '{{ translate('Sorry, There is no size guide found for this product.') }}');
                return false;
            }
            $.ajax({
                type: "GET",
        url: "{{ route('size-charts-show', '') }}/" +id, data: {}, success: function(data) {
        $('#size-chart-show-modal.modal-title').html(name); $('#size-chart-show-modal .modal-body').html(data);
        $('#size-chart-show-modal').modal('show'); } }); } </script>
@endsection
