@php
    // $date = date('l d M Y - H:i', $detailedProduct->event_start_date);

    if ('fr' == app()->getLocale()) {
        setlocale(LC_TIME, 'fr_FR.UTF-8');
    } elseif ('ma' == app()->getLocale()) {
        setlocale(LC_TIME, 'ar_MA.UTF-8');
    } else {
        setlocale(LC_TIME, 'en_EN.UTF-8');
    }
    // Format the date
    $date = strftime('%A %d %B %Y - %H:%M', $detailedProduct->event_start_date);
    // Output the formatted date

    $location = $detailedProduct->event_city;

    $type = $detailedProduct->type;
    $timestamp = $detailedProduct->event_start_date;
    $_date = new DateTime("@$timestamp");
    $currentDate = new DateTime();
@endphp

<div class="text-left">
    @if ($detailedProduct->brand != null)
        {{-- Brand --}}
        <div class="row">
            <div class="product-brand col-sm-12 text-center">
                <a href="{{ route('products.brand', $detailedProduct->brand->slug) }}"
                    class="text-reset hov-text-primary fs-14 fw-700">
                    <img class="lazyload h-100px h-md-110px mx-auto has-transition p-2 p-sm-4"
                        src="{{ isset($detailedProduct->brand->brandLogo->file_name) ? my_asset($detailedProduct->brand->brandLogo->file_name) : static_asset('assets/img/placeholder.jpg') }}"
                        alt="{{ $detailedProduct->brand->getTranslation('name') }}"></a>
            </div>
        </div>
    @endif

    {{-- Date --}}
    <div class="row no-gutters mt-5">
        <div class="col-sm-12 text-center text-white">
            <h5>{{ $date }}</h5>
        </div>
    </div>

    {{-- Location --}}
    <div class="row no-gutters mt-1">
        <div class="col-sm-12 text-center text-white">
            {{-- <h5>{{ $location }}</h5> --}}
            <h5>{{ optional($detailedProduct->city)->getTranslation('name') }}</h5>
        </div>
    </div>

    <!-- For auction product -->
    <form id="option-choice-form">
        @csrf
        <div class="row no-gutters mt-1">
            <div class="col-sm-12">
                <div class="">
                    <!-- Discount Price -->
                    <strong class=" fs-16 fw-700 text-primary">
                        @if (null !== $detailedProduct->choice_options && count(json_decode($detailedProduct->choice_options)) > 0)
                            @foreach (json_decode($detailedProduct->choice_options) as $key => $choice)
                                <select name="attribute_id_{{ $choice->attribute_id }}" class="pricebox">
                                    @foreach ($choice->values as $_key => $value)
                                        <option value="{{ $value }}">
                                            <div class="d-flex justify-content-between">
                                                <span>{{ $value }} -
                                                    {!! format_price($detailedProduct->stocks->where('variant', $value)->first()->price) !!}
                                                </span>
                                            </div>
                                        </option>
                                    @endforeach
                                </select>
                            @endforeach
                        @else
                            <div class="pricebox text-right">{!! home_discounted_base_price($detailedProduct) !!}</div>
                        @endif
                    </strong>
                </div>
            </div>
        </div>

        <div class="d-flex mt-2">
            <input type="hidden" name="id" value="{{ $detailedProduct->id }}">
            <!-- Quantity + Add to cart -->
            <div class="row no-gutters mb-0 inputcol">
                <div class="col-sm-12">
                    <div class="product-quantity d-flex align-items-center">
                        <div class="row no-gutters bg-white align-items-center crea-plus-minus "
                            style="width: 100%;border-radius: 5px">
                            <button class="btn col-auto btn-icon btn-sm btn-light rounded-0" type="button"
                                data-type="minus" data-field="quantity" disabled="">
                                <i class="las la-minus"></i>
                            </button>
                            <input type="number" name="quantity"
                                class="col border-0 text-center flex-grow-1 fs-16 input-number" placeholder="1"
                                value="{{ $detailedProduct->min_qty }}" min="{{ $detailedProduct->min_qty }}"
                                max="10" lang="en">
                            <button class="btn col-auto btn-icon btn-sm btn-light rounded-0" type="button"
                                data-type="plus" data-field="quantity">
                                <i class="las la-plus"></i>
                            </button>
                        </div>
                        @php
                            $qty = 0;
                            foreach ($detailedProduct->stocks as $key => $stock) {
                                $qty += $stock->qty;
                            }
                        @endphp
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <span class="text-danger" id="qty-message"></span>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Total Price -->
            @if ($detailedProduct->auction_product)
            @else
                <!-- Add to cart & Buy now Buttons -->
                <div class="mt-0 pl-1 btncol">
                    @if ($detailedProduct->digital == 0)
                        <button type="button" data-stock="{{ $detailedProduct->stocks->first()->qty }}"
                            class="btn btn-secondary-base add-to-cart fw-600 min-w-150px rounded-0 text-dark"
                            @if (Auth::check() || get_Setting('guest_checkout_activation') == 1) onclick="addToCart()" @else onclick="showLoginModal()" @endif>
                            {{ translate('Add to cart') }}
                        </button>
                        <button type="button" class="btn btn-secondary out-of-stock fw-600 d-none" disabled>
                            <i class="la la-cart-arrow-down"></i> {{ translate('Out of Stock') }}
                        </button>
                    @elseif ($detailedProduct->digital == 1)
                        @if ($_date < $currentDate || 0 == $detailedProduct->stocks->first()->qty)
                            <button type="button" disabled data-stock="{{ $detailedProduct->stocks->first()->qty }}"
                                class="btn btn-secondary-base add-to-cart fw-600 min-w-150px rounded-0 text-white">
                                @if (0 == $detailedProduct->stocks->first()->qty)
                                    {{ translate('Sold out') }}
                                @else
                                    @if ('event' == $detailedProduct->nature)
                                        {{ translate('Event is over') }}
                                    @else
                                        @if ('deal' == $detailedProduct->nature)
                                            {{ translate('End of deal') }}
                                        @else
                                            {{ translate('Add to cart') }}
                                        @endif
                                    @endif
                                @endif
                            </button>
                        @else
                            <button type="button" data-stock="{{ $detailedProduct->stocks->first()->qty }}"
                                class="btn btn-secondary-base add-to-cart fw-600 min-w-150px rounded-0 text-white"
                                @if (Auth::check() || get_Setting('guest_checkout_activation') == 1) onclick="addToCart()" @else onclick="showLoginModal()" @endif>
                                @if ('event' == $detailedProduct->nature)
                                    {{ translate('Buy') }}
                                @else
                                    {{ translate('Add to cart') }}
                                @endif
                            </button>
                        @endif
                    @endif
                </div>
            @endif
        </div>
    </form>

    {{-- Event Count Down --}}
    @if ($_date > $currentDate)
        <div class="row no-gutters mt-4">
            <div class="col-sm-12 text-center text-white">
                @if ('event' == $detailedProduct->nature)
                    <div class="countdown-text">{{ translate('Hurry up! Purchase your tickets now') }}</div>
                @endif

                @if ('deal' == $detailedProduct->nature)
                    <div class="countdown-text">{{ translate('"Hurry up! Grab your deals now!"') }}</div>
                @endif
            </div>
            <div class="col-sm-12">
                <div class="crea-count-down-circle"
                    end-date="{{ date('Y/m/d H:i:s', $detailedProduct->event_start_date) }}">
                </div>
            </div>
        </div>
    @endif

    <!-- Share -->
    <div class="row no-gutters mt-4">
        <div class="col-sm-12 text-center text-white">
            {{-- <div class="sharetxt">{{ translate('Share') }}</div> --}}
            @if ('event' == $detailedProduct->nature)
                <div class="sharetxt">{{ translate('Share this event') }}</div>
            @endif

            @if ('deal' == $detailedProduct->nature)
                <div class="sharetxt">{{ translate('Share this deal') }}</div>
            @endif
        </div>
        <div class="col-sm-12">
            <div class="crea-share"></div>
        </div>
    </div>

    {{-- Map --}}
    <div class="row mt-4">
        <div class="col-md-12 crea-map">
            @if ($detailedProduct->map_link != '')
                <p class="localisationtitle">{{ translate('Localisation') }}</p>

                {!! $detailedProduct->map_link !!}
            @endif
        </div>
    </div>
</div>
