@extends('frontend.layouts.app')
@if (isset($category_id))
    @php
        $meta_title = $category->meta_title;
        $meta_description = $category->meta_description;
    @endphp
@else
    @php
        $meta_title = get_setting('meta_title');
        $meta_description = get_setting('meta_description');
    @endphp
@endif
@section('meta_title'){{ $meta_title }}@stop
@section('meta_description'){{ $meta_description }}@stop
@section('meta')
    <!-- Schema.org markup for Google+ -->
    <meta itemprop="name" content="{{ $meta_title }}">
    <meta itemprop="description" content="{{ $meta_description }}">
    <!-- Twitter Card data -->
    <meta name="twitter:title" content="{{ $meta_title }}">
    <meta name="twitter:description" content="{{ $meta_description }}">
    <!-- Open Graph data -->
    <meta property="og:title" content="{{ $meta_title }}" />
    <meta property="og:description" content="{{ $meta_description }}" />
@endsection
@section('content')
  {{-- Featured Products --}}
    @php
        if (isset($category) && !empty($category)):
            $default_bg_color = get_setting('featured_products_bg_color');
            $default_bg_image = get_setting('featured_products_bg_image');

            $bg_color = get_setting($category->slug . '_featured_products_bg_color') ?: $default_bg_color;
            $bg_image = get_setting($category->slug . '_featured_products_bg_image');
        endif;
    @endphp 

    <section class="mb-4 pt-4">
        <div class="container sm-px-0 pt-2">
            <form class="" id="search-form" action="" method="GET">
                <div class="row">
                    <!-- Contents -->
                    <div class="col-xl-12 categoryblocs ">

                        <!-- Top Filters -->
                        <div class="text-left py-0 px-2">
                            <div class="row gutters-5 flex-wrap align-items-center">
                                <div class="col-lg-12 col-12">
                                    <h1 class="fs-20 fs-md-24 fw-700 text-dark text-center">
                                        @if (isset($category_id))
                                            {{ $category->getTranslation('name') }}
                                        @elseif(isset($query))
                                            {{ translate('Search result for ') }}"{{ $query }}"
                                        @elseif(isset($location))
                                            {{ translate('Search result for ') }}"{{ $location }}"
                                        @else
                                            {{ translate('All Products') }}
                                        @endif
                                    </h1>
                                    <input type="hidden" name="keyword" value="{{ $query }}">
                                </div>
                            </div>
                        </div>
 
                        <!-- Products -->
                        <div class="px-3">
                            <div id="content"
                                class="row gutters-16 row-cols-xxl-4 row-cols-xl-3 row-cols-lg-3 row-cols-md-2 row-cols-sm-2 row-cols-1   ">
                                @foreach ($products as $key => $product)
                                    <div class="col custompad-10 has-transition z-1">
                                        @include(
                                            'frontend.' .
                                                get_setting('homepage_select') .
                                                '.partials.product_box_5',
                                            ['product' => $product]
                                        )
                                    </div>
                                @endforeach
                            </div>
                            <div class="row">
                                <div class="col-md-12 text-center">
                                    <div class="loading" id="loading" style="display: none">
                                        {{ translate('Loading ...') }}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </section>
@endsection
@section('script')
    <script type="text/javascript">
        function getUrlParameters() {
            const params = {};
            const queryString = window.location.search.slice(1);
            const pairs = queryString.split('&');

            for (let i = 0; i < pairs.length; i++) {
                const pair = pairs[i].split('=');
                const key = decodeURIComponent(pair[0]);
                const value = decodeURIComponent(pair[1] || '');
                params[key] = value;
            }

            return params;
        }

        $(document).ready(function() {
            $('.crea-listing-carousel').slick({
                slidesToShow: 7,
                slidesToScroll: 2,
                dots: true,
                arrows: true,
                speed: 1100,
                autoplay: true,
                autoplaySpeed: 2000,
                prevArrow: $('.slider-prev-btn'),
                nextArrow: $('.slider-next-btn'),
                responsive: [{
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: 5,
                            slidesToScroll: 1

                        }
                    },
                    {
                        breakpoint: 850,
                        settings: {
                            slidesToShow: 3,
                            slidesToScroll: 1,
                        }
                    },
                    {
                        breakpoint: 480,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 1,
                        }
                    }
                ]
            });

            var page = 2; // Initial page number
            var loading = false; // To prevent multiple requests
            var stopLoading = false

            function loadMoreContent() {
                if (loading || stopLoading) return;

                loading = true;
                console.log('Debug Load more');
                $('#loading').show();
                $.ajax({
                    url: '{{ route('products.load_more') }}',
                    method: 'GET',
                    data: {
                        page: page,
                        location: $('[name="location[]"]:checked').map(function() {
                            return this.value;
                        }).get(),
                        price: $('[name="price[]"]:checked').map(function() {
                            return this.value;
                        }).get(),
                        city: $('[name="city[]"]:checked').map(function() {
                            return this.value;
                        }).get(),
                        rating: $('[name="rating[]"]:checked').map(function() {
                            return this.value;
                        }).get(),
                        sort_by: $('[name="sort_by"]').val(),
                        category_id: @isset($category_id)
                            {{ $category_id }}
                        @else
                            null
                        @endif
                    },
                    success: function(response) {
                        if (0 < response.products.length) {
                            $('#content').append(response.products); // Append new content
                            CREA.plugins.countDownBox();
                            page++;
                            loading = false;
                            $('#loading').hide();
                        } else {
                            stopLoading = true;
                            loading = false;
                            $('#loading').hide();
                        }
                    },
                    error: function() {
                        // loading = false;
                        // $('#loading').hide();
                    }
                });
            }

            $(window).scroll(function() {
                if ($(window).scrollTop() + $(window).height() >= $(document).height() - 450) {
                    loadMoreContent();
                }
            });

            // loadMoreContent(); // Initial load


        });

        function filter() {
            $('#search-form').submit();
        }

        function clear_search() {
            $('[name="keyword"]').val('');
            $('#search-form').submit();
        }

        function rangefilter(arg) {
            $('input[name=min_price]').val(arg[0]);
            $('input[name=max_price]').val(arg[1]);
            filter();
        }
    </script>
@endsection
