@extends('frontend.layouts.app')
@if (isset($category_id))
    @php
        $meta_title = $category->meta_title;
        $meta_description = $category->meta_description;
    @endphp
@else
    @php
        $meta_title = get_setting('meta_title');
        $meta_description = get_setting('meta_description');
    @endphp
@endif
@section('meta_title'){{ $meta_title }}@stop
@section('meta_description'){{ $meta_description }}@stop
@section('meta')
    <!-- Schema.org markup for Google+ -->
    <meta itemprop="name" content="{{ $meta_title }}">
    <meta itemprop="description" content="{{ $meta_description }}">
    <!-- Twitter Card data -->
    <meta name="twitter:title" content="{{ $meta_title }}">
    <meta name="twitter:description" content="{{ $meta_description }}">
    <!-- Open Graph data -->
    <meta property="og:title" content="{{ $meta_title }}" />
    <meta property="og:description" content="{{ $meta_description }}" />
@endsection

@section('content')
    {{-- Breadcrumb --}}
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <ul
                    class="product-breadcrumb breadcrumb align-items-baseline justify-content-center justify-content-lg-start bg-transparent p-0">
                    <li class="breadcrumb-item has-transition opacity-60 hov-opacity-100">
                        <a class="text-reset" href="{{ route('home') }}">{{ translate('Home') }}</a>
                    </li>
                    <li class="breadcrumb-item">
                        <span>{{ translate('Shop') }}</span>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    {{-- Featured Category --}}
    @if (0 < count(get_popular_categories()))
        <div class="container">
            @include('frontend.shop.partials.featured_categories')
        </div>
    @endif

    <div id="mobile-filters-wrapper" style="display:none;">
        <div class="overlay"></div>
        <div class="mobile-filters shop-sidebar">
            <div class="filters-header">
                <span>{{ translate('Filters') }}</span>
                <button id="mobile-filters-close-btn"><i class="fa fa-times"></i></button>
            </div>
            <div class="bg-white">
                @include('frontend.shop.partials.widgets.categories')
            </div>
            <div class="bg-white">
                @include('frontend.shop.partials.widgets.mobile_filters')
            </div>
        </div>
    </div>

    <section class="mb-4 pt-4">
        <div class="container sm-px-0 pt-2">
            <div class="row">
                @if (0 < count($products))
                    <div class="col-md-2 shop-sidebar">
                        <div class="bg-white">
                            @include('frontend.shop.partials.widgets.filters')
                        </div>

                        <div class="bg-white mt-3">
                            @include('frontend.shop.partials.widgets.categories')
                        </div>
                    </div>

                    <div class="col-md-10 shop-content">
                        <div class="d-flex justify-content-between bg-white mb-3">
                            <div id="shop-mobile-filters-btn" style="display: none;">
                                <i class="fa fa-filter"></i>
                            </div>

                            <div class="shop-products-count">
                                <span id="products-count">{{ $products_count }}</span>
                                <span>{{ translate(' Products') }}</span>
                            </div>

                            <div class="shop-sort-by d-flex">
                                <span>{{ translate('Sort by ') }}</span>
                                <select class="form-control form-control-sm aiz-selectpicker rounded-0" name="sort_by"
                                    onchange="filter()">
                                    <option value="newest"
                                        @isset($sort_by) @if ($sort_by == 'newest') selected @endif @endisset>
                                        {{ translate('Newest') }}
                                    </option>
                                    <option value="oldest"
                                        @isset($sort_by) @if ($sort_by == 'oldest') selected @endif @endisset>
                                        {{ translate('Oldest') }}
                                    </option>
                                    <option value="price-asc"
                                        @isset($sort_by) @if ($sort_by == 'price-asc') selected @endif @endisset>
                                        {{ translate('Price low to high') }}
                                    </option>
                                    <option value="price-desc"
                                        @isset($sort_by) @if ($sort_by == 'price-desc') selected @endif @endisset>
                                        {{ translate('Price high to low') }}
                                    </option>
                                    <option value="alphabet-asc"
                                        @isset($sort_by) @if ($sort_by == 'alphabet-asc') selected @endif @endisset>
                                        {{ translate('Alphabetical A to Z') }}
                                    </option>
                                    <option value="alphabet-desc"
                                        @isset($sort_by) @if ($sort_by == 'alphabet-desc') selected @endif @endisset>
                                        {{ translate('Alphabetical Z to A') }}
                                    </option>
                                </select>
                            </div>
                        </div>

                        <form class="" id="search-form" action="" method="GET">
                            <div class="row">
                                <!-- Contents -->
                                <div class="col-xl-12 categoryblocs">
                                    <!-- Products -->
                                    <div class="px-3 position-relative">
                                        <div id="content-loader" class="spinner-overlay" style="display: none;">
                                            <div class="spinner"></div>
                                        </div>

                                        <div id="content"
                                            class="row gutters-16 row-cols-xxl-4 row-cols-xl-3 row-cols-lg-3 row-cols-md-2 row-cols-sm-2 row-cols-1">

                                            @foreach ($products as $key => $product)
                                                <div class="col custompad-10 has-transition z-1">
                                                    @include('frontend.partials.boxes.product_box_1', [
                                                        'product' => $product,
                                                    ])
                                                </div>
                                            @endforeach
                                        </div>
                                        @if (0 < count($products) && $products_count > count($products))
                                            <div class="text-center">
                                                <button type="button" id="shop-load-more-btn" class="btn btn-primary"
                                                    onclick="loadMore()">{{ translate('Load More ...') }}</button>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                @else
                    <div class="m-auto text-center not-found">
                        <img src="{{ static_asset('assets/img/sad-face.webp') }}">
                        <h2>{{ translate('Ouch... looks like our magic stock is empty!') }}</h2>
                        <p>{{ translate('There are no items matching your search... but don\'t be too hasty!') }}
                        </p>
                        <p>{{ translate('Our store is full of interesting offers.') }}</p>

                        <div class="row">
                            <div class="col-md-5">
                                <div class="info-box">
                                    <img src="{{ static_asset('assets/img/search-page.webp') }}">
                                    <span>{{ translate('Try a different or more general keyword.') }}</span>
                                </div>
                            </div>
                            <div class="col-md-2"><img src="{{ static_asset('assets/img/ou.webp') }}"></div>
                            <div class="col-md-5">
                                <div class="info-box">
                                    <img src="{{ static_asset('assets/img/promotion.webp') }}">
                                    <span>{{ translate('Browse our current offers :') }} <a
                                            href="#">{{ translate('See promotions') }}</a></span>
                                </div>
                            </div>
                        </div>

                        <a class="back-to-home-btn" href="{{ route('home') }}">{{ translate('Back to home') }}</a>
                    </div>
                @endif
            </div>
        </div>
    </section>
@endsection

@section('script')
    <script type="text/javascript">
        function getUrlParameters() {
            const params = {};
            const queryString = window.location.search.slice(1);
            const pairs = queryString.split('&');

            for (let i = 0; i < pairs.length; i++) {
                const pair = pairs[i].split('=');
                const key = decodeURIComponent(pair[0]);
                const value = decodeURIComponent(pair[1] || '');
                params[key] = value;
            }

            return params;
        }

        $(document).ready(function() {
            $('#shop-mobile-filters-btn').on('click', function() {
                $("#mobile-filters-wrapper").show();
            });

            $('#mobile-filters-wrapper .overlay, #mobile-filters-close-btn').on('click', function() {
                $("#mobile-filters-wrapper").hide();
            });


            var page = 2; // Initial page number
            var loading = false; // To prevent multiple requests
            var stopLoading = false

            function loadMoreContent() {
                if (loading || stopLoading) return;

                loading = true;
                console.log('Debug Load more');
                $('#loading').show();
                $.ajax({
                    url: '{{ route('products.load_more') }}',
                    method: 'GET',
                    data: {
                        page: page,
                        location: $('[name="location[]"]:checked').map(function() {
                            return this.value;
                        }).get(),
                        price: $('[name="price[]"]:checked').map(function() {
                            return this.value;
                        }).get(),
                        city: $('[name="city[]"]:checked').map(function() {
                            return this.value;
                        }).get(),
                        rating: $('[name="rating[]"]:checked').map(function() {
                            return this.value;
                        }).get(),
                        sort_by: $('[name="sort_by"]').val(),
                        category_id: @isset($category_id)
                            {{ $category_id }}
                        @else
                            null
                        @endif
                    },
                    success: function(response) {
                        if (0 < response.products.length) {
                            $('#content').append(response.products); // Append new content
                            CREA.plugins.countDownBox();
                            page++;
                            loading = false;
                            $('#loading').hide();
                        } else {
                            stopLoading = true;
                            loading = false;
                            $('#loading').hide();
                        }
                    },
                    error: function() {
                        // loading = false;
                        // $('#loading').hide();
                    }
                });
            }

            // $(window).scroll(function() {
            //     if ($(window).scrollTop() + $(window).height() >= $(document).height() - 450) {
            //         loadMoreContent();
            //     }
            // });

            // loadMoreContent(); // Initial load


        });

        function filter() {
            $('#content-loader').show();

            let url = '{{ route('search.by_ajax') }}';
            @if ($category_id)
                url = '{{ route('search.by_ajax', $category_id) }}';
            @endif

            const sort_by = $('[name="sort_by"]').val();
            const availability = $('[name="availability"]').val();
            const min_price = $('[name="min_price"]').val();
            const max_price = $('[name="max_price"]').val();
            const ratings = $('[name="rating[]"]:checked').map(function() {
                return $(this).val();
            }).get();
            const cities = $('[name="target_city[]"]:checked').map(function() {
                return $(this).val();
            }).get();

            // const attributes = $('[name="attributes[]"]:checked').map(function() {
            //     let attr = [];

            //     attr[$(this).data('attribute')].push($(this).val());
            //     return attr;
            // }).get();

            const attributes = {};
            $('[name="attributes[]"]:checked').each(function() {
                let attribute = $(this).data('attribute');
                if (!attributes[attribute]) {
                    attributes[attribute] = [];
                }
                attributes[attribute].push($(this).val());
            });


            console.log('Debug attributes:', attributes);

            $.ajax({
                url: url,
                type: 'GET',
                async: false,
                data: {
                    sort_by: sort_by,
                    availability: availability,
                    min_price: min_price,
                    max_price: max_price,
                    ratings: ratings,
                    cities: cities,
                    selectedAttributes: attributes
                },
                dataType: 'json',
                success: function(response) {
                    const content = response.products;
                    const count = response.count;
                    const has_more_pages = response.has_more_pages;

                    $('#content').html(content);
                    $('#products-count').html(count);

                    if (false == has_more_pages) {
                        $('#shop-load-more-btn').hide();
                    } else {
                        $('#shop-load-more-btn').show();
                    }

                    setTimeout(function() {
                        $('#content-loader').hide();
                    }, 1000);
                },
                error: function(error) {
                    console.error(error);
                }
            });
        
            $("#mobile-filters-wrapper").hide();
        }

        function loadMore() {
            let url = '{{ route('search.by_ajax') }}';
            @if ($category_id)
                url = '{{ route('search.by_ajax', $category_id) }}';
            @endif

            let page = 2
            const sort_by = $('[name="sort_by"]').val();
            const availability = $('[name="availability"]:checked').val();
            const min_price = $('[name="min_price"]').val();
            const max_price = $('[name="max_price"]').val();
            const ratings = $('[name="rating[]"]:checked').map(function() {
                return $(this).val();
            }).get();
            const cities = $('[name="target_city[]"]:checked').map(function() {
                return $(this).val();
            }).get();

            $.ajax({
                url: url,
                type: 'GET',
                data: {
                    page: page,
                    sort_by: sort_by,
                    availability: availability,
                    min_price: min_price,
                    max_price: max_price,
                    ratings: ratings,
                    cities: cities
                },
                dataType: 'json',
                success: function(response) {
                    const content = response.products;
                    const has_more_pages = response.has_more_pages;

                    $('#content').append(content);

                    if (false == has_more_pages) {
                        $('#shop-load-more-btn').hide();
                    } else {
                        $('#shop-load-more-btn').show();
                    }

                    page++;
                },
                error: function(error) {
                    console.error(error);
                }
            });
        }

        function clear_search() {
            $('[name="keyword"]').val('');
            $('#search-form').submit();
            $("#mobile-filters-wrapper").hide();
        }

        function rangefilter(arg) {
            $('input[name=min_price]').val(arg[0]);
            $('input[name=max_price]').val(arg[1]);
            filter();
        }
    </script>
@endsection
